<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

$routes->get('/', 'Home::index');
$routes->post('/getPilihBidang', 'BidangController::getPilihBidang');
// $routes->post('/pushRegister', 'PesertaController::store');
// $routes->get('/daftar', 'PesertaController::registerPeserta');
$routes->post('/getPilihSubPrio', 'SubppController::getPilihSubPrio');


// $routes->group('admin', ['filter' => 'role:perserta,admin '], function ($routes) {
//     $routes->resource('perserta', ['filter' => 'role:perserta']);
//     $routes->resource('admin', ['filter' => 'role:admin']);
// });


// //universitas
// $routes->get('/universitas', 'UniversitasController::index');
// $routes->get('/universitas/create', 'UniversitasController::create');
// $routes->get('universitas/(:num)', 'UniversitasController::index/$1');
// $routes->post('/universitas', 'UniversitasController::store');
// $routes->put('/universitas/(:num)', 'UniversitasController::update/$1');
// $routes->delete('/universitas/(:num)', 'UniversitasController::destroy/$1');

// //bidang
$routes->get('/bidang', 'BidangController::index');
$routes->get('/bidang/create', 'BidangController::create');
$routes->get('bidang/(:num)', 'BidangController::index/$1');
$routes->post('/bidang', 'BidangController::store');
$routes->put('/bidang/(:num)', 'BidangController::update/$1');
$routes->delete('/bidang/(:num)', 'BidangController::destroy/$1');


//sma
$routes->get('/sma', 'SmaController::index', ['filter' => 'role:admin']);
$routes->get('/sma/create', 'SmaController::create', ['filter' => 'role:admin']);
$routes->get('sma/(:num)', 'SmaController::index/$1', ['filter' => 'role:admin']);
$routes->post('/sma', 'SmaController::store', ['filter' => 'role:admin']);
$routes->put('/sma/(:num)', 'SmaController::update/$1', ['filter' => 'role:admin']);
$routes->delete('/sma/(:num)', 'SmaController::destroy/$1', ['filter' => 'role:admin']);
// pd Perangkat Daerah
$routes->get('/pd', 'PdController::index', ['filter' => 'role:admin']);
$routes->get('/pd/create', 'PdController::create', ['filter' => 'role:admin']);
$routes->get('pd/(:num)', 'PdController::index/$1', ['filter' => 'role:admin']);
$routes->post('/pd', 'PdController::store', ['filter' => 'role:admin']);
$routes->put('/pd/(:num)', 'PdController::update/$1', ['filter' => 'role:admin']);
$routes->delete('/pd/(:num)', 'PdController::destroy/$1', ['filter' => 'role:admin']);
// //prioritas
$routes->get('/prioritas', 'PrioritasController::index');
$routes->get('/prioritas', 'PrioritasController::index', ['filter' => 'role:admin']);
$routes->get('prioritas/create', 'PrioritasController::create', ['filter' => 'role:admin']);
$routes->get('prioritas/(:num)', 'PrioritasController::index/$1', ['filter' => 'role:admin']);
$routes->post('/prioritas', 'PrioritasController::store', ['filter' => 'role:admin']);
$routes->put('/prioritas/(:num)', 'PrioritasController::update/$1', ['filter' => 'role:admin']);
$routes->delete('/prioritas/(:num)', 'PrioritasController::destroy/$1', ['filter' => 'role:admin']);

// //subpp
$routes->get('/subpp', 'SubppController::index');
$routes->get('/subpp/create', 'SubppController::create');
$routes->get('subpp/(:num)', 'SubppController::index/$1');
$routes->post('/subpp', 'SubppController::store');
$routes->put('/subpp/(:num)', 'SubppController::update/$1');
$routes->delete('/subpp/(:num)', 'SubppController::destroy/$1');


// Urusan  
$routes->get('/urusan', 'UrusanController::index', ['filter' => 'role:admin']);
$routes->get('/urusan/create', 'UrusanController::create', ['filter' => 'role:admin']);
$routes->get('urusan/(:num)', 'UrusanController::index/$1', ['filter' => 'role:admin']);
$routes->post('/urusan', 'UrusanController::store', ['filter' => 'role:admin']);
$routes->put('/urusan/(:num)', 'UrusanController::update/$1', ['filter' => 'role:admin']);
$routes->delete('/urusan/(:num)', 'UrusanController::destroy/$1', ['filter' => 'role:admin']);

// status
$routes->get('status', 'StatusController::index', ['filter' => 'role:admin']);
$routes->get('/status/create', 'StatusController::create', ['filter' => 'role:admin']);
$routes->get('status/(:num)', 'StatusController::index/$1', ['filter' => 'role:admin']);
$routes->post('/status', 'StatusController::store', ['filter' => 'role:admin']);
$routes->put('/status/(:num)', 'StatusController::update/$1', ['filter' => 'role:admin']);
$routes->delete('/status/(:num)', 'StatusController::destroy/$1', ['filter' => 'role:admin']);


// Usualan
$routes->get('usulan', 'UsulanController::index');
$routes->get('/usulan/create', 'UsulanController::create');
$routes->get('usulan/(:num)', 'UsulanController::index/$1');
$routes->post('/usulan', 'UsulanController::store');
$routes->put('/usulan/(:num)', 'UsulanController::update/$1');
$routes->delete('/usulan/(:num)', 'UsulanController::destroy/$1');


// Publikasi
$routes->get('publikasi', 'PublikasiController::index', ['filter' => 'role:admin']);
$routes->get('/publikasi/create', 'PublikasiController::create', ['filter' => 'role:admin']);
$routes->get('publikasi/(:num)', 'PublikasiController::index/$1', ['filter' => 'role:admin']);
$routes->post('/publikasi', 'PublikasiController::store', ['filter' => 'role:admin']);
$routes->put('/publikasi/(:num)', 'PublikasiController::update/$1', ['filter' => 'role:admin']);
$routes->delete('/publikasi/(:num)', 'PublikasiController::destroy/$1', ['filter' => 'role:admin']);

//disposisi
$routes->get('disposisi', 'DisposisiController::index', ['filter' => 'role:admin']);
$routes->get('/disposisi/create', 'DisposisiController::create', ['filter' => 'role:admin']);
$routes->get('disposisi/(:num)', 'DisposisiController::index/$1', ['filter' => 'role:admin']);
// $routes->post('/disposisi', 'DisposisiController::store', ['filter' => 'role:admin']);
$routes->put('/disposisi/(:num)', 'DisposisiController::update/$1', ['filter' => 'role:admin']);
$routes->delete('/disposisi/(:num)', 'DisposisiController::destroy/$1', ['filter' => 'role:admin']);

// $routes->get('/sliders', 'SliderController::index');
// $routes->get('/sliders/create', 'SliderController::create');
// $routes->get('sliders/(:num)', 'SliderController::index/$1');
// $routes->post('/sliders', 'SliderController::store');
// $routes->put('/sliders/(:num)', 'SliderController::update/$1');
// $routes->delete('/sliders/(:num)', 'SliderController::destroy/$1');


//peserta
$routes->get('/peserta', 'PesertaController::index', ['filter' => 'role:admin']);
$routes->get('/seleksiawal', 'SeleksiController::index', ['filter' => 'role:admin']);

$routes->get('/prosesawal', 'SeleksiController::prosesSeleksiAwal', ['filter' => 'role:admin']);
$routes->get('/scoreawal/(:num)', 'SeleksiController::scoreSeleksiAwal/$1', ['filter' => 'role:admin']);
$routes->post('/simpanseleksiawal', 'SeleksiController::simpanSeleksiAwal', ['filter' => 'role:admin']);

$routes->get('/prosesakhir', 'SeleksiController::akhir', ['filter' => 'role:admin']);
$routes->get('/scoreakhir/(:num)', 'SeleksiController::scoreSeleksiAkhir/$1', ['filter' => 'role:admin']);
$routes->post('/simpanseleksiakhir', 'SeleksiController::simpanSeleksiAkhir', ['filter' => 'role:admin']);

$routes->get('/lolosseleksi', 'SeleksiController::lolosSeleksi', ['filter' => 'role:admin']);

//lampiran
$routes->get('/lampiran', 'LampiranController::index', ['filter' => 'role:perserta']);
$routes->get('/lampiran/pdf', 'LampiranController::insertPdf', ['filter' => 'role:perserta']);
$routes->get('/lampiran/images', 'LampiranController::insertImg', ['filter' => 'role:perserta']);
$routes->delete('/lampiran/(:num)', 'LampiranController::destroy/$1', ['filter' => 'role:perserta']);

$routes->post('/lampiran/saveimages', 'LampiranController::saveImages', ['filter' => 'role:perserta']);
$routes->post('/lampiran/savepdf', 'LampiranController::savePdf', ['filter' => 'role:perserta']);

$routes->get('/download', 'DownloadController::index', ['filter' => 'role:perserta']);

$routes->get('/users', 'UsersController::index', ['filter' => 'role:admin']);
$routes->post('/users', 'UsersController::store', ['filter' => 'role:admin']);
$routes->get('/users/create', 'UsersController::create', ['filter' => 'role:admin']);
$routes->get('/users/pass', 'UsersController::UbahPassword');
$routes->put('/users', 'UsersController::update');


$routes->get('/kolaborasi/(:num)', 'KolaborasiController::index/$1', ['filter' => 'role:admin']);
$routes->get('/kolaborasi/create/(:num)', 'KolaborasiController::create/$1', ['filter' => 'role:admin']);
$routes->get('/kolaborasi/edit/(:num)', 'KolaborasiController::edit/$1', ['filter' => 'role:admin']);
$routes->post('/kolaborasi', 'KolaborasiController::store', ['filter' => 'role:admin']);
$routes->put('/kolaborasi/(:num)', 'KolaborasiController::update/$1', ['filter' => 'role:admin']);
$routes->delete('/kolaborasi/(:num)', 'KolaborasiController::destroy/$1', ['filter' => 'role:admin']);


// Monitoring
$routes->get('monitoring/', 'MonitoringController::index', ['filter' => 'role:admin']);
$routes->get('monitoring/(:num)', 'MonitoringController::index/$1', ['filter' => 'role:admin']);
// $routes->get('/publikasi/create', 'PublikasiController::create', ['filter' => 'role:admin']);
// $routes->get('publikasi/(:num)', 'PublikasiController::index/$1', ['filter' => 'role:admin']);
// $routes->post('/publikasi', 'PublikasiController::store', ['filter' => 'role:admin']);
$routes->put('/monitoring/(:num)', 'MonitoringController::update/$1', ['filter' => 'role:admin']);
// $routes->delete('/publikasi/(:num)', 'PublikasiController::destroy/$1', ['filter' => 'role:admin']);


//report 
$routes->get('report-usulan/', 'ReportController::cetakUsulan', ['filter' => 'role:admin']);
$routes->get('report-publikasi/', 'ReportController::cetakPublikasi', ['filter' => 'role:admin']);
$routes->get('report-monitoring/', 'ReportController::cetakMonitoring', ['filter' => 'role:admin']);
