<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Database\Migrations\Bidang;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\PdModel;
use App\Models\BidangModel;
use App\Models\CrudModel;

class BidangController extends BaseController
{
    protected $pdModel;
    protected $bidangModel;
    protected $crudModel;
    protected $title = " Bidang Perangkat Daerah ";
    protected $tabel = "bidang";
    protected $perPage = 10;
    public function  __construct()
    {
        $this->bidangModel = new BidangModel();
        $this->pdModel = new PdModel();
        $this->crudModel = new CrudModel();
        $this->data['title'] = $this->title;
        $this->data['tabel'] = $this->tabel;
        $this->data['ls_pd'] = $this->getpd();
    }

    public function index($bidangId = null)
    {
        $curentPage = $this->request->getVar('pages') ? $this->request->getVar('pages') : 1;
        $this->data['pages'] = $this->perPage * ($curentPage - 1);
        if ($bidangId) {
            $bidang = $this->bidangModel->find($bidangId);
            if (!$bidang) {
                return redirect()->to($this->tabel);
            }

            $this->data['lcid'] = $bidang->id_bidang;
            $this->data['lcnama'] = $bidang->nama;
            $this->data['lcketerangan'] = $bidang->keterangan;
            $this->data['lcid_pd'] = $bidang->id_pd;
            // $this->data['lcid_universitas'] = $fakultas->id_universitas;
            // $this->data['ls_pd'] = $this->getpd();
            // $this->data['lcquota'] = $sma->quota;
            // $this->data['ls_universitas'] = $this->getUniversitas();


            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $this->getBidang();

        return view('pages/' . $this->tabel . '/list', $this->data);
    }

    private function getBidang()
    {
        // d($this->request->getVar('caridata'));
        $this->crudModel = new CrudModel();
        $caridata = $this->request->getVar('caridata');
        if ($caridata) {
            $listData = $this->crudModel->getFindData('v_bidang', 'nama', $caridata);
        } else {
            $listData = $this->crudModel->getAllData('v_bidang', 'nama');
        }

        // dd($listData->get()->getResult());
        $this->data['listdata'] = $listData->paginate($this->perPage, "v_bidang");
        $this->data['pager'] = $listData->pager;
    }

    // menampilkan form input data 
    public function create()
    {
        return view('pages/' . $this->tabel . '/form', $this->data);
    }

    // menyimpan  data yg di input dari form
    public function store()
    {
        $nmTitle = 'Nama ' . $this->title;
        $rules = [
            'lcid_pd' => 'required|min_length[0]',
            'lcketerangan' => 'required|min_length[10]',
            // 'lcpd' => 'required',
            // 'lcquota' => 'required',

        ];
        $messages = [
            'lcnama' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],
            // 'lcketerangan' => [
            //     'required' => 'Tidak boleh kosong',
            //     'min_length' => ' Panjang Keterangan Minimal 5 Karakter',
            // ],
            'lcid_pd' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => 'PD Harus Di pilih',
            ],
        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;
            $this->data['lcnama'] = $this->request->getVar('lcnama');
            $this->data['lcketerangan'] = $this->request->getVar('lcketerangan');
            $this->data['lcid_pd'] = $this->request->getVar('lcid_pd');
            // $this->data['lcquota'] = $this->request->getVar('lcquota');

            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $params = [
            'nama' => $this->request->getVar('lcnama'),
            'keterangan' => $this->request->getVar('lcketerangan'),
            'id_pd' => $this->request->getVar('lcid_pd'),
            // 'quota' => $this->request->getVar('lcquota'),
        ];
        if ($this->bidangModel->save($params)) {
            return redirect()->to($this->tabel);
        }
    }

    // menrubah data yg di input dari form
    public function update($id)
    {
        $nmTitle = 'Nama ' . $this->title;
        $rules = [
            'lcid_pd' => 'required|min_length[0]',
            'lcketerangan' => 'required|min_length[10]',
            // 'lcstatus' => 'required',
            // 'lcquota' => 'required|greater_than[0]',

        ];
        $messages = [
            'lcnama' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5 Karakter',
            ],
            'lcketerangan' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => ' Panjang Keterangan Minimal 5 Karakter',
            ],
            'lcid_pd' => [
                'required' => 'Tidak boleh kosong',
            ],

        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;

            $this->data['lcid'] = $id;
            $this->data['lcnama'] = $this->request->getVar('lcnama');
            $this->data['lcketerangan'] = $this->request->getVar('lcketerangan');
            $this->data['lcid_pd'] = $this->request->getVar('lcid_Pd');
            // $this->data['lcquota'] = $this->request->getVar('lcquota');

            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $params = [
            'id_bidang' => $id,
            'nama' => $this->request->getVar('lcnama'),
            'keterangan' => $this->request->getVar('lcketerangan'),
            'id_pd' => $this->request->getVar('lcid_pd'),
            // 'quota' => $this->request->getVar('lcquota'),
        ];
        if ($this->bidangModel->save($params)) {
            return redirect()->to($this->tabel);
        }
    }

    // hapus permanen dari tabel
    public function destroy($id)
    {
        $bidang = $this->bidangModel->find($id);
        if (!$bidang) {
            return redirect()->to($this->tabel);
        }

        if ($this->bidangModel->delete($bidang->id_bidang)) {
            return redirect()->to($this->tabel);
        }
    }

    private function getPd()
    {
        $list  = [
            0 => "Pilih Perangkat Daerah (PD)"
        ];
        if ($this->pdModel->countAllResults() > 0) {
            foreach ($this->pdModel->findAll() as $row) {
                $list[$row->id_pd] = $row->nama;
            }
        } else {
            $list  = [
                0 => "Tidak Ada  Perangkat Daerah (PD)"
            ];
        }

        return $list;
    }

    public function getPilihBidang()
    {

        $lcId = $this->request->getVar('id');
        $lsDataList = $this->bidangModel->listBidang($lcId)->get()->getResult();
        $ls_bidang = [
            0 => "Pilih Bidang"
        ];
        if ($lsDataList) {
            foreach ($lsDataList as $row) {
                $ls_bidang[$row->id_bidang] = $row->nama;
            }
        } else {
            $ls_bidang = [
                0 => "Tidak Ada Bidang"
            ];
        }

        return form_dropdown('lcid_bidang', $ls_bidang, isset($lcid_bidang) ? $lcid_bidang : '', 'class="form-control select2"');
    }
}
