<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Database\Migrations\Disposisi;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\DisposisiModel;
use App\Models\PdModel;
use App\Models\BidangModel;
use App\Models\PrioritasModel;
use App\Models\SubppModel;
use App\Models\UrusanModel;
// use App\Models\UsulannModel;
use App\Models\StatusModel;
use App\Models\CrudModel;

class DisposisiController extends BaseController
{
    protected $disposisiModel;
    protected $pdModel;
    protected $bidangModel;
    protected $prioritasModel;
    protected $subppModel;
    protected $urusanModel;
    // protected $usulanModel;
    protected $statusModel;
    protected $crudModel;
    protected $title = " Disposisi Kajian ";
    protected $tabel = "disposisi"; // tabel tetap menggunakan tabel isi usulan
    protected $perPage = 10;
    public function  __construct()
    {
        $this->disposisiModel = new DisposisiModel();
        $this->pdModel = new PdModel();
        $this->bidangModel = new BidangModel();
        $this->prioritasModel = new PrioritasModel();
        $this->subppModel = new SubppModel();
        $this->urusanModel = new UrusanModel();
        $this->statusModel = new StatusModel();
        $this->crudModel = new CrudModel();
        $this->data['title'] = $this->title;
        $this->data['tabel'] = $this->tabel;
        $this->data['ls_pd'] = $this->getpd();
        $this->data['ls_bidang'] =  [
            0 => "Tidak Ada Data  bidang"
        ];
        // $this->data['ls_bidang'] = $this->getbidang();

        $this->data['ls_prioritas'] = $this->getprioritas();
        $this->data['ls_subpp'] = [
            0 => "Pilih Sub Prioritas Pembangunan"
        ];
        $this->data['ls_urusan'] = $this->geturusan();
        $this->data['ls_tahun'] = $this->getTahun();
        $this->data['ls_status'] = $this->getstatus();
    }

    public function index($disposisiId = null)
    {
        $curentPage = $this->request->getVar('pages') ? $this->request->getVar('pages') : 1;
        $this->data['pages'] = $this->perPage * ($curentPage - 1);
        if ($disposisiId) {
            $disposisi = $this->disposisiModel->find($disposisiId);
            if (!$disposisi) {
                return redirect()->to($this->tabel);
            }
            $this->data['lcid'] = $disposisi->id_usulan;
            $this->data['lcid_pd'] = $disposisi->id_pd;
            $this->data['lcid_bidang'] = $disposisi->id_bidang;
            $this->data['lcid_prioritas'] = $disposisi->id_prioritas;
            $this->data['lcid_subpp'] = $disposisi->id_subpp;
            $this->data['lcid_urusan'] = $disposisi->id_urusan;
            $this->data['lcnama'] = $disposisi->nama;
            $this->data['lctahun'] = $disposisi->tahun;
            $this->data['lclatarbelakang'] = $disposisi->latarbelakang;
            $this->data['lcpermasalahan'] = $disposisi->permasalahan;
            $this->data['lckolaborasi'] = $disposisi->kolaborasi;
            $this->data['lcdokumen'] = $disposisi->dokumen;
            $this->data['lcid_status'] = $disposisi->id_status;
            $this->data['lcketerangan'] = $disposisi->keterangan;

            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $this->getdisposisi();

        return view('pages/' . $this->tabel . '/list', $this->data);
    }

    private function getdisposisi()
    {
        // d($this->request->getVar('caridata'));
        $this->crudModel = new CrudModel();
        $caridata = $this->request->getVar('caridata');
        if ($caridata) {
            $listData = $this->crudModel->cariDataDisposisi($caridata);
        } else {
            $listData = $this->crudModel->allDataDisposisi();
        }

        $this->data['listdata'] = $listData->paginate($this->perPage, 'v_usulan');
        $this->data['pager'] = $listData->pager;
    }

    public function create()
    {
        return view('pages/' . $this->tabel . '/form', $this->data);
    }

    // menyimpan  data yg di input dari form
    public function store()
    {
        $rules = [
            'lcid_pd' => 'required|min_length[0]',
            'lcid_bidang' => 'required|min_length[0]',
            'lcid_prioritas' => 'required|min_length[0]',
            'lcid_subpp' => 'required|min_length[0]',
            'lcid_urusan' => 'required|min_length[0]',
            'lcid_status' => 'required|min_length[0]',
            'lctahun' => 'required|min_length[0]',
            'lcnama' => 'required|min_length[5]',
            'lclatarbelakang' => 'required|min_length[10]',
            'lcpermasalahan' => 'required|min_length[10]',
            'lckolaborasi' => 'required|min_length[10]',
            'lcketerangan' => 'required|min_length[10]',

        ];
        $messages = [
            'lcnama' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],
            'lctahun' => [
                'required' => 'Tidak boleh kosong',

            ],
            'lclatarbelakang' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],
            'lcpermasalahan' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],
            'lckolaborasi' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],
            'lcketerangan' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],
            'lcid_pd' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => '  Harus Di pilih',
            ],
            'lcid_bidang' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => ' Harus Di pilih',
            ],
            'lcid_prioritas' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => ' Harus Di pilih',
            ],
            'lcid_subpp' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => 'Harus Di pilih',
            ],

            'lcid_urusan' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => 'Harus Di pilih',
            ],

            'lcid_status' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => 'Harus Di pilih',
            ],

        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;
            $this->data['lcnama'] = $this->request->getVar('lcnama');
            $this->data['lctahun'] = $this->request->getVar('lctahun');
            $this->data['lclatarbelakang'] = $this->request->getVar('lclatarbelakang');
            $this->data['lcpermasalahan'] = $this->request->getVar('lcpermasalahan');
            $this->data['lckolaborasi'] = $this->request->getVar('lckolaborasi');
            $this->data['lcketerangan'] = $this->request->getVar('lcketerangan');
            $this->data['lcid_pd'] = $this->request->getVar('lcid_pd');
            $this->data['lcid_bidang'] = $this->request->getVar('lcid_bidang');
            $this->data['lcid_prioritas'] = $this->request->getVar('lcid_prioritas');
            $this->data['lcid_subpp'] = $this->request->getVar('lcid_subpp');
            $this->data['lcid_urusan'] = $this->request->getVar('lcid_urusan');
            $this->data['lcid_status'] = $this->request->getVar('lcid_status');

            return view('pages/' . $this->tabel . '/form', $this->data);
        };
        $params = [
            'nama' => $this->request->getVar('lcnama'),
            'tahun' => $this->request->getVar('lctahun'),
            'latarbelakang' => $this->request->getVar('lclatarbelakang'),
            'permasalahan' => $this->request->getVar('lcpermasalahan'),
            'kolaborasi' => $this->request->getVar('lckolaborasi'),
            'keterangan' => $this->request->getVar('lcketerangan'),
            'id_pd' => $this->request->getVar('lcid_pd'),
            'id_bidang' => $this->request->getVar('lcid_bidang'),
            'id_prioritas' => $this->request->getVar('lcid_prioritas'),
            'id_subpp' => $this->request->getVar('lcid_subpp'),
            'id_urusan' => $this->request->getVar('lcid_urusan'),
            'id_status' => $this->request->getVar('lcid_status'),

        ];
        $lcDataLampiran  = $this->disposisiModel->save($params);
        $lcDataId = $this->disposisiModel->getInsertID();

        if ($lcDataLampiran) {
            $path = $_FILES['image']['name'];
            $lcNamaFile = substr($path, 0, strlen($path) - 4);
            $ext = pathinfo($path, PATHINFO_EXTENSION);
            $data_banner = $lcNamaFile . '_' . $lcDataId . '.' . $ext;
            $this->crudModel->file_pdf($lcNamaFile, "lampiran", $lcDataId, '', 'no', '.' . $ext);

            // $ext = pathinfo($path, PATHINFO_EXTENSION);
            // $data_banner['lampiran'] = 'document_' . $lcDataId . '.' . $ext;
            // $lcInsertImage = $this->crudModel->file_pdf("document", "lampiran", $lcDataId, '', 'no', '.' . $ext);

            $params = [
                'id_disposisi' => $lcDataId,
                'dokumen' => $data_banner,
            ];

            $this->disposisiModel->save($params);

            // dd(substr($path, 0, strlen($path) - 4));
            return redirect()->to($this->tabel);
        }
        if ($this->disposisiModel->save($params)) {
            return redirect()->to($this->tabel);
        }
    }

    // menrubah data yg di input dari form
    public function update($id)
    {
        $rules = [
            'lcid_status' => 'required|min_length[0]',
            'lcketerangan' => 'required|min_length[5]',
        ];
        $messages = [
            'lcid_status' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => 'Harus Di pilih',
            ],
            'lcketerangan' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],

        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;

            $disposisi = $this->disposisiModel->find($id);
            $this->data['lcid'] = $disposisi->id_usulan;
            $this->data['lcid_pd'] = $disposisi->id_pd;
            $this->data['lcid_bidang'] = $disposisi->id_bidang;
            $this->data['lcid_prioritas'] = $disposisi->id_prioritas;
            $this->data['lcid_subpp'] = $disposisi->id_subpp;
            $this->data['lcid_urusan'] = $disposisi->id_urusan;
            $this->data['lcnama'] = $disposisi->nama;
            $this->data['lctahun'] = $disposisi->tahun;
            $this->data['lclatarbelakang'] = $disposisi->latarbelakang;
            $this->data['lcpermasalahan'] = $disposisi->permasalahan;
            $this->data['lckolaborasi'] = $disposisi->kolaborasi;
            $this->data['lcdokumen'] = $disposisi->dokumen;
            $this->data['lcid_status'] = $this->request->getVar('lcid_status');
            $this->data['lcketerangan'] = $this->request->getVar('lcketerangan');

            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $params = [

            'id_usulan' => $id,
            'keterangan' => $this->request->getVar('lcketerangan'),
            'id_status' => $this->request->getVar('lcid_status'),

        ];
        if ($this->disposisiModel->save($params)) {
            return redirect()->to($this->tabel);
        }
    }

    // hapus permanen dari tabel
    public function destroy($id)
    {
        $disposisi = $this->disposisiModel->find($id);
        if (!$disposisi) {
            return redirect()->to($this->tabel);
        }

        if ($this->disposisiModel->delete($disposisi->id_disposisi)) {
            return redirect()->to($this->tabel);
        }
    }

    private function getPd()
    {
        $pd = [
            0 => "Pilih PD"
        ];
        if ($this->pdModel->countAllResults() > 0) {
            foreach ($this->pdModel->findAll() as $row) {
                $pd[$row->id_pd] = $row->nama;
            }
        } else {
            $pd  = [
                0 => "Tidak Ada PD"
            ];
        }

        return $pd;
    }


    public function getPilihBidang()
    {
        $lcKode = $this->request->getVar('pd');
        $lsDataList = $this->bidangModel->listBidang($lcKode)->get()->getResult();
        $ls_bidang = [
            0 => "Pilih Bidang"
        ];
        if ($lsDataList) {
            foreach ($lsDataList as $row) {
                $ls_bidang[$row->kode] = $row->nama;
            }
        } else {
            $ls_bidang = [
                0 => "Tidak Ada Data "
            ];
        }

        return form_dropdown('lcid_bidang', $ls_bidang, isset($lcid_bidang) ? $lcid_bidang : '', 'class="form-control select2"');
    }

    private function getPrioritas()
    {

        $list  = [
            0 => "Pilih Prioritas Pembangunan"
        ];
        if ($this->prioritasModel->countAllResults() > 0) {
            foreach ($this->prioritasModel->findAll() as $row) {
                $list[$row->id_prioritas] = $row->nama;
            }
        } else {
            $list  = [
                0 => "Tidak Ada  Data"
            ];
        }

        return $list;
    }
    private function getSubpp()
    {

        $list  = [
            0 => "Pilih Sub Prioritas Pembangunan"
        ];
        if ($this->subppModel->countAllResults() > 0) {
            foreach ($this->subppModel->findAll() as $row) {
                $list[$row->id_subpp] = $row->nama;
            }
        } else {
            $list  = [
                0 => "Tidak Ada  Data"
            ];
        }

        return $list;
    }
    private function getUrusan()
    {

        $list  = [
            0 => "Pilih Urusan"
        ];
        if ($this->urusanModel->countAllResults() > 0) {
            foreach ($this->urusanModel->findAll() as $row) {
                $list[$row->id_urusan] = $row->nama;
            }
        } else {
            $list  = [
                0 => "Tidak Ada  Data"
            ];
        }

        return $list;
    }
    private function getStatus()
    {

        $list  = [
            0 => "Pilih Disposisi"
        ];
        if ($this->statusModel->countAllResults() > 0) {
            foreach ($this->statusModel->findAll() as $row) {
                $list[$row->id_status] = $row->nama;
            }
        } else {
            $list  = [
                0 => "Tidak Ada  Data"
            ];
        }

        return $list;
    }
    private function getTahun()
    {
        $list['2021'] = '2021';
        $list['2022'] = '2022';
        $list['2023'] = '2023';
        $list['2024'] = '2024';
        $list['2025'] = '2025';
        $list['2026'] = '2026';
        $list['2027'] = '2027';
        $list['2028'] = '2028';
        $list['2029'] = '2029';
        $list['2030'] = '2030';
        return $list;
    }
}
