<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\KolaborasiModel;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\PdModel;
use App\Models\BidangModel;
use App\Models\UsulanModel;
use PhpParser\Builder\Use_;

class KolaborasiController extends BaseController
{
    protected $kolaborasiModel;
    protected $pdModel;
    protected $bidangModel;
    protected $usulanModel;
    protected $title = "Kolaborasi";
    protected $tabel = "kolaborasi";
    protected $perPage = 10;
    public function  __construct()
    {
        $this->kolaborasiModel = new KolaborasiModel();
        $this->pdModel = new PdModel();
        $this->bidangModel = new BidangModel();
        $this->usulanModel = new UsulanModel();
        $this->data['title'] = $this->title;
        $this->data['tabel'] = $this->tabel;
        $this->data['ls_pd'] = $this->getpd();
        $this->data['ls_bidang'] =  [
            0 => "Tidak Ada Data  bidang"
        ];

        // $this->data['ls_status'] = $this->getStatus();
    }
    public function index($idusulan = null)
    {
        $curentPage = $this->request->getVar('page_v_kaloborasi') ? $this->request->getVar('page_v_kaloborasi') : 1;
        $this->data['pages'] = $this->perPage * ($curentPage - 1);
        if ($idusulan == null) {
            return redirect()->to('usulan');
        }
        $this->getKolab($idusulan);
        $this->data['idUsulan'] = $idusulan;
        $this->usulanModel = new UsulanModel();
        $judulUsulan = $this->usulanModel->find($idusulan)->nama;
        $this->data['title'] = $this->title . ' ( ' . $judulUsulan . ' )';

        return view('pages/' . $this->tabel . '/list', $this->data);
    }

    public function edit($idKola = null)
    {

        if ($idKola) {
            $kolabo = $this->kolaborasiModel->find($idKola);
            if (!$kolabo) {
                return redirect()->to($this->tabel);
            }
            $this->data['lcid'] = $kolabo->id_kolaborasi;
            $this->data['lcid_bidang'] = $kolabo->id_bidang;
            $this->data['lcketerangan'] = $kolabo->keterangan;
            $this->data['lcid_pd'] = $kolabo->id_pd;
            $this->data['idUsulan'] = $kolabo->id_usulan;

            return view('pages/' . $this->tabel . '/form', $this->data);
        }
    }

    private function getKolab($idusulan)
    {
        // d($this->request->getVar('caridata'));
        $caridata = $this->request->getVar('caridata');
        if ($caridata) {
            $listData = $this->kolaborasiModel->cariData($idusulan, $caridata);
        } else {
            $listData = $this->kolaborasiModel->allData($idusulan);
        }

        $this->data['listdata'] = $listData->paginate($this->perPage, 'v_kolaborasi');
        $this->data['pager'] = $listData->pager;
    }

    public function create($id_usulan)
    {
        $this->data['idUsulan'] = $id_usulan;
        return view('pages/' . $this->tabel . '/form', $this->data);
    }

    public function store()
    {
        $rules = [
            'lcid_pd' => 'required|min_length[0]',
            'lcid_bidang' => 'required|min_length[0]',
            'lcketerangan' => 'required|min_length[10]',


        ];
        $messages = [
            'lcid_pd' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => 'PD Harus Di pilih',
            ],
            'lcid_bidang' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => 'Bidang Harus Di pilih',
            ],
            'lcketerangan' => [
                'required' => 'Tidak boleh kosong',
            ],
        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;
            $this->data['lcid_bidang'] = $this->request->getVar('lcid_bidang');
            $this->data['lcketerangan'] = $this->request->getVar('lcketerangan');
            $this->data['lcid_pd'] = $this->request->getVar('lcid_pd');
            $this->data['lcidUsulan'] = $this->request->getVar('lcidUsulan');

            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $params = [
            'id_bidang' => $this->request->getVar('lcid_bidang'),
            'keterangan' => $this->request->getVar('lcketerangan'),
            'id_pd' => $this->request->getVar('lcid_pd'),
            'id_usulan' => $this->request->getVar('lcidUsulan'),
        ];
        if ($this->kolaborasiModel->save($params)) {
            return redirect()->to('kolaborasi/' .  $this->request->getVar('lcidUsulan'));
        }
    }

    public function update($id)
    {
        $rules = [
            'lcid_pd' => 'required|min_length[0]',
            'lcid_bidang' => 'required|min_length[0]',
            'lcketerangan' => 'required|min_length[10]',


        ];
        $messages = [
            'lcid_pd' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => 'PD Harus Di pilih',
            ],
            'lcid_bidang' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => 'Bidang Harus Di pilih',
            ],
            'lcketerangan' => [
                'required' => 'Tidak boleh kosong',
            ],
        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;
            $this->data['lcid_bidang'] = $this->request->getVar('lcid_bidang');
            $this->data['lcketerangan'] = $this->request->getVar('lcketerangan');
            $this->data['lcid_pd'] = $this->request->getVar('lcid_pd');
            $this->data['lcidUsulan'] = $this->request->getVar('lcidUsulan');

            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $params = [
            'id_kolaborasi' => $id,
            'id_bidang' => $this->request->getVar('lcid_bidang'),
            'keterangan' => $this->request->getVar('lcketerangan'),
            'id_pd' => $this->request->getVar('lcid_pd'),
            'id_usulan' => $this->request->getVar('lcidUsulan'),
        ];
        if ($this->kolaborasiModel->save($params)) {
            return redirect()->to('kolaborasi/' .  $this->request->getVar('lcidUsulan'));
        }
    }

    // hapus permanen dari tabel
    public function destroy($id)
    {
        $kola = $this->kolaborasiModel->find($id);
        if (!$kola) {
            return redirect()->to($this->tabel);
        }

        if ($this->kolaborasiModel->delete($kola->id_kolaborasi)) {
            return redirect()->to($this->tabel);
        }
    }


    private function getPd()
    {
        $list  = [
            0 => "Pilih Perangkat Daerah (PD)"
        ];
        if ($this->pdModel->countAllResults() > 0) {
            foreach ($this->pdModel->findAll() as $row) {
                $list[$row->id_pd] = $row->nama;
            }
        } else {
            $list  = [
                0 => "Tidak Ada  Perangkat Daerah (PD)"
            ];
        }

        return $list;
    }
}
