<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\PdModel;
use App\Models\BidangModel;
use App\Models\PublikasiModel;
use App\Models\CrudModel;
use App\Models\StatusModel;

class MonitoringController extends BaseController
{
    protected $pdModel;
    protected $bidangModel;
    protected $publikasiModel;
    protected $crudModel;
    protected $statusModel;
    protected $title = "Monitoring dan Evaluasi ";
    protected $tabel = "monitoring";
    protected $perPage = 10;

    public function  __construct()
    {
        $this->publikasiModel = new PublikasiModel();
        $this->pdModel = new PdModel();
        $this->bidangModel = new BidangModel();
        $this->crudModel = new CrudModel();
        $this->statusModel = new StatusModel();
        $this->data['title'] = $this->title;
        $this->data['tabel'] = $this->tabel;
        $this->data['ls_pd'] = $this->getpd();
        $this->data['ls_bidang'] =  [
            0 => "Tidak Ada Data  bidang"
        ];
        $this->data['ls_tahun'] = $this->getTahun();
        $this->data['ls_tahunTL'] = $this->getTahun();
        $this->data['ls_status'] = $this->getstatus();
    }
    public function index($publikasiId = null)
    {
        $curentPage = $this->request->getVar('pages') ? $this->request->getVar('pages') : 1;
        $this->data['pages'] = $this->perPage * ($curentPage - 1);
        if ($publikasiId) {
            $publikasi = $this->publikasiModel->find($publikasiId);
            if (!$publikasi) {
                return redirect()->to($this->tabel);
            }

            $this->data['lcid'] = $publikasi->id_publikasi;
            $this->data['lcid_pd'] = $publikasi->id_pd;

            $this->data['lcnama'] = $publikasi->nama;
            $this->data['lctahun'] = $publikasi->tahun;
            $this->data['lcketerangan'] = $publikasi->keterangan;
            $this->data['lcimages'] = $publikasi->image;

            $this->data['lctahunTL'] = $publikasi->tahub;
            $this->data['lcid_status'] = $publikasi->id_status;
            $this->data['lckajian'] = $publikasi->kajian;

            $this->data['lcdokumen'] = $publikasi->dokumen;


            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $this->getPublikasi();

        return view('pages/' . $this->tabel . '/list', $this->data);
    }

    private function getPublikasi()
    {
        // d($this->request->getVar('caridata'));
        $this->crudModel = new CrudModel();
        $caridata = $this->request->getVar('caridata');
        if ($caridata) {
            $listData = $this->crudModel->cariDataPublikasi($caridata);
        } else {
            $listData = $this->crudModel->allDataPublikasi();
        }

        $this->data['listdata'] = $listData->paginate($this->perPage, 'v_publikasi');
        $this->data['pager'] = $listData->pager;
    }

    // menrubah data yg di input dari form
    public function update($id)
    {
        $rules = [
            'lcid_status' => 'greater_than[0]',
            'lctahunTL' => 'greater_than[2020]',
            'lckajian' => 'required|min_length[5]',
        ];
        $messages = [
            'lctahunTL' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => 'tahun harus di atas 2020'

            ],
            'lckajian' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],
            'lcid_status' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => ' Harus Di pilih',
            ],

        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;

            $this->data['lcid'] = $id;
            $publikasi = $this->publikasiModel->find($id);
            $this->data['lcid'] = $publikasi->id_publikasi;
            $this->data['lcid_pd'] = $publikasi->id_pd;

            $this->data['lcnama'] = $publikasi->nama;
            $this->data['lctahun'] = $publikasi->tahun;
            $this->data['lcketerangan'] = $publikasi->keterangan;
            $this->data['lcimages'] = $publikasi->image;
            $this->data['lcdokumen'] = $publikasi->dokumen;

            $this->data['lctahunTL'] = $this->request->getVar('lctahunTL');
            $this->data['lcid_status'] = $this->request->getVar('lcid_status');
            $this->data['lckajian'] = $this->request->getVar('lckajian');


            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $params = [
            'id_publikasi' => $id,
            'tahub' => $this->request->getVar('lctahunTL'),
            'kajian' => $this->request->getVar('lckajian'),
            'id_status' => $this->request->getVar('lcid_status'),

        ];
        if ($this->publikasiModel->save($params)) {
            return redirect()->to($this->tabel);
        }
    }

    private function getPd()
    {
        $pd = [
            0 => "Pilih PD"
        ];
        if ($this->pdModel->countAllResults() > 0) {
            foreach ($this->pdModel->findAll() as $row) {
                $pd[$row->id_pd] = $row->nama;
            }
        } else {
            $pd  = [
                0 => "Tidak Ada PD"
            ];
        }

        return $pd;
    }

    private function getStatus()
    {

        $list  = [
            0 => "Pilih Monitoring"
        ];
        if ($this->statusModel->countAllResults() > 0) {
            foreach ($this->statusModel->findAll() as $row) {
                $list[$row->id_status] = $row->nama;
            }
        } else {
            $list  = [
                0 => "Tidak Ada  Data"
            ];
        }

        return $list;
    }

    private function getTahun()
    {
        $list['2021'] = '2021';
        $list['2022'] = '2022';
        $list['2023'] = '2023';
        $list['2024'] = '2024';
        $list['2025'] = '2025';
        $list['2026'] = '2026';
        $list['2027'] = '2027';
        $list['2028'] = '2028';
        $list['2029'] = '2029';
        $list['2030'] = '2030';
        return $list;
    }
}
