<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Database\Migrations\Publikasi;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\PdModel;
use App\Models\BidangModel;
// use App\Models\PrioritasModel;
// use App\Models\SubppModel;
// use App\Models\UrusanModel;
use App\Models\PublikasiModel;
use App\Models\CrudModel;

class PublikasiController extends BaseController
{
    protected $pdModel;
    protected $bidangModel;
    protected $publikasiModel;
    protected $crudModel;
    protected $title = " Publikasi Kajian ";
    protected $tabel = "publikasi";
    protected $perPage = 10;
    public function  __construct()
    {
        $this->publikasiModel = new PublikasiModel();
        $this->pdModel = new PdModel();
        $this->bidangModel = new BidangModel();
        $this->crudModel = new CrudModel();
        $this->data['title'] = $this->title;
        $this->data['tabel'] = $this->tabel;
        $this->data['ls_pd'] = $this->getpd();
        $this->data['ls_bidang'] =  [
            0 => "Tidak Ada Data  bidang"
        ];
        // $this->data['ls_bidang'] = $this->getbidang();
        // $this->data['ls_prioritas'] = $this->getprioritas();
        // $this->data['ls_subpp'] = [
        //     0 => "Pilih Sub Prioritas Pembangunan"
        // ];
        // $this->data['ls_urusan'] = $this->geturusan();
        $this->data['ls_tahun'] = $this->getTahun();
    }

    public function index($publikasiId = null)
    {
        $curentPage = $this->request->getVar('pages') ? $this->request->getVar('pages') : 1;
        $this->data['pages'] = $this->perPage * ($curentPage - 1);
        if ($publikasiId) {
            $publikasi = $this->publikasiModel->find($publikasiId);
            if (!$publikasi) {
                return redirect()->to($this->tabel);
            }

            $this->data['lcid'] = $publikasi->id_publikasi;
            $this->data['lcid_pd'] = $publikasi->id_pd;

            $this->data['lcnama'] = $publikasi->nama;
            $this->data['lctahun'] = $publikasi->tahun;
            $this->data['lcketerangan'] = $publikasi->keterangan;


            $this->data['lcdokumen'] = $publikasi->dokumen;


            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $this->getPublikasi();

        return view('pages/' . $this->tabel . '/list', $this->data);
    }

    private function getPublikasi()
    {
        // d($this->request->getVar('caridata'));
        $this->crudModel = new CrudModel();
        $caridata = $this->request->getVar('caridata');
        if ($caridata) {
            $listData = $this->crudModel->cariDataPublikasi($caridata);
        } else {
            $listData = $this->crudModel->allDataPublikasi();
        }

        $this->data['listdata'] = $listData->paginate($this->perPage, 'v_publikasi');
        $this->data['pager'] = $listData->pager;
    }


    public function create()
    {
        return view('pages/' . $this->tabel . '/form', $this->data);
    }

    // menyimpan  data yg di input dari form
    public function store()
    {
        $nmTitle = 'Nama ' . $this->title;
        $rules = [
            'lcid_pd' => 'required|min_length[0]',
            'lcid_bidang' => 'required|min_length[0]',
            'lctahun' => 'required|min_length[0]',
            'lcnama' => 'required|min_length[5]',
            'lcketerangan' => 'required|min_length[5]',

        ];
        $messages = [
            'lcnama' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],
            'lctahun' => [
                'required' => 'Tidak boleh kosong',

            ],
            'lcketerangan' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],
            'lcid_pd' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => '  Harus Di pilih',
            ],
            'lcid_bidang' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => ' Harus Di pilih',
            ],
            // 'lcid_prioritas' => [
            //     'required' => 'Tidak boleh kosong',
            //     'greater_than' => ' Harus Di pilih',
            // ],
            // 'lcid_subpp' => [
            //     'required' => 'Tidak boleh kosong',
            //     'greater_than' => 'Harus Di pilih',
            // ],

            // 'lcid_urusan' => [
            //     'required' => 'Tidak boleh kosong',
            //     'greater_than' => 'Harus Di pilih',
            // ],

        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;
            $this->data['lcnama'] = $this->request->getVar('lcnama');
            $this->data['lctahun'] = $this->request->getVar('lctahun');
            $this->data['lcketerangan'] = $this->request->getVar('lcketerangan');
            $this->data['lcid_pd'] = $this->request->getVar('lcid_pd');
            $this->data['lcid_bidang'] = $this->request->getVar('lcid_bidang');

            return view('pages/' . $this->tabel . '/form', $this->data);
        };
        $params = [
            'nama' => $this->request->getVar('lcnama'),
            'tahun' => $this->request->getVar('lctahun'),
            'keterangan' => $this->request->getVar('lcketerangan'),
            'id_pd' => $this->request->getVar('lcid_pd'),
            'id_bidang' => $this->request->getVar('lcid_bidang'),
        ];

        $lcDataLampiran  = $this->publikasiModel->save($params);
        $lcDataId = $this->publikasiModel->getInsertID();

        if ($lcDataLampiran) {
            $path = $_FILES['image']['name'];
            $lcNamaFile = substr($path, 0, strlen($path) - 4);
            $ext = pathinfo($path, PATHINFO_EXTENSION);
            $data_images = 'pub_' . $lcNamaFile . '_' . $lcDataId . '.' . $ext;
            $this->crudModel->file_up('pub_' . $lcNamaFile, "lampiran", $lcDataId, '', 'no', '.' . $ext);

            $path = $_FILES['pdf']['name'];
            $lcNamaFile = substr($path, 0, strlen($path) - 4);
            $ext = pathinfo($path, PATHINFO_EXTENSION);
            $data_pdf = 'pub_' . $lcNamaFile . '_' . $lcDataId . '.' . $ext;
            $this->crudModel->file_pdf('pub_' . $lcNamaFile, "lampiran", $lcDataId, '', 'no', '.' . $ext);

            $params = [
                'id_publikasi' => $lcDataId,
                'image' => $data_images,
                'dokumen' => $data_pdf,
            ];

            $this->publikasiModel->save($params);

            // dd(substr($path, 0, strlen($path) - 4));
            return redirect()->to($this->tabel);
        }
        if ($this->publikasiModel->save($params)) {
            return redirect()->to($this->tabel);
        }
    }

    // menrubah data yg di input dari form
    public function update($id)
    {
        $nmTitle = 'Nama ' . $this->title;
        $rules = [
            'lcid_pd' => 'required|min_length[0]',
            'lcid_bidang' => 'required|min_length[0]',
            'lclnama' => 'required|min_length[0]',
            'lcltahun' => 'required|min_length[0]',
            'lcketerangan' => 'required|min_length[5]',
        ];
        $messages = [
            'lcnama' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],
            'lctahun' => [
                'required' => 'Tidak boleh kosong',

            ],
            'lcketerangan' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],
            'lcid_pd' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => '  Harus Di pilih',
            ],
            'lcid_bidang' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => ' Harus Di pilih',
            ],

        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;

            $this->data['lcid'] = $id;
            $this->data['validation'] = $this->validator;
            $this->data['lcnama'] = $this->request->getVar('lcnama');
            $this->data['lctahun'] = $this->request->getVar('lctahun');
            $this->data['lcketerangan'] = $this->request->getVar('lcketerangan');
            $this->data['lcid_pd'] = $this->request->getVar('lcid_pd');
            $this->data['lcid_bidang'] = $this->request->getVar('lcid_bidang');
            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $params = [
            'nama' => $this->request->getVar('lcnama'),
            'tahun' => $this->request->getVar('lctahun'),
            'keterangan' => $this->request->getVar('lclatarbelakang'),
            'id_pd' => $this->request->getVar('lcid_pd'),
            'id_bidang' => $this->request->getVar('lcid_bidang'),

        ];
        if ($this->publikasiModel->save($params)) {
            return redirect()->to($this->tabel);
        }
    }

    // hapus permanen dari tabel
    public function destroy($id)
    {
        $publikasi = $this->publikasiModel->find($id);
        if (!$publikasi) {
            return redirect()->to($this->tabel);
        }

        if ($this->publikasiModel->delete($publikasi->id_publikasi)) {
            return redirect()->to($this->tabel);
        }
    }

    private function getPd()
    {
        $pd = [
            0 => "Pilih PD"
        ];
        if ($this->pdModel->countAllResults() > 0) {
            foreach ($this->pdModel->findAll() as $row) {
                $pd[$row->id_pd] = $row->nama;
            }
        } else {
            $pd  = [
                0 => "Tidak Ada PD"
            ];
        }

        return $pd;
    }


    public function getPilihBidang()
    {
        $lcKode = $this->request->getVar('pd');
        $lsDataList = $this->bidangModel->listBidang($lcKode)->get()->getResult();
        $ls_bidang = [
            0 => "Pilih Bidang"
        ];
        if ($lsDataList) {
            foreach ($lsDataList as $row) {
                $ls_bidang[$row->kode] = $row->nama;
            }
        } else {
            $ls_bidang = [
                0 => "Tidak Ada Data "
            ];
        }

        return form_dropdown('lcid_bidang', $ls_bidang, isset($lcid_bidang) ? $lcid_bidang : '', 'class="form-control select2"');
    }

    private function getTahun()
    {
        $list['2021'] = '2021';
        $list['2022'] = '2022';
        $list['2023'] = '2023';
        $list['2024'] = '2024';
        $list['2025'] = '2025';
        $list['2026'] = '2026';
        $list['2027'] = '2027';
        $list['2028'] = '2028';
        $list['2029'] = '2029';
        $list['2030'] = '2030';
        return $list;
    }
}
