<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\CrudModel;
use App\Models\UsulanModel;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class ReportController extends BaseController
{

    protected $crudModel;
    protected $usulanModel;

    public function __construct()
    {
        $this->crudModel = new CrudModel();
        $this->usulanModel = new UsulanModel();
    }


    public function index()
    {
        //
    }

    public function cetakUsulan()
    {
        $this->crudModel = new CrudModel();
        $dataListUsulan = $this->crudModel->reportUsulan();
        if ($dataListUsulan) {
            $spreadsheet = new Spreadsheet();

            $spreadsheet->setActiveSheetIndex(0)->setCellValue("A1", "Usulan Kajian");

            $spreadsheet->setActiveSheetIndex(0)->setCellValue("A2", "Tanggal : " . tanggal() . "/" . user()->nama);

            $spreadsheet->setActiveSheetIndex(0)->setCellValue("A3", "No");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("B3", "Perangkat Daerah");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("C3", "Bidang");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("D3", "Prioritas Pembangunan");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("E3", "Sub Prioritas Pembangunan");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("F3", "Urusan");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("G3", "Judul");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("H3", "Tahun");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("I3", "Latar Belakang");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("J3", "Permasalahan");

            $baris = 4;
            $lcNo = 1;
            foreach ($dataListUsulan as $datalist) {
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("A" . $baris, $lcNo);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("B" . $baris, $datalist->pd);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("C" . $baris, $datalist->bidang);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("D" . $baris, $datalist->prioritas);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("E" . $baris, $datalist->subpp);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("F" . $baris, $datalist->urusan);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("G" . $baris, $datalist->nama);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("H" . $baris, $datalist->tahun);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("I" . $baris, $datalist->latarbelakang);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("J" . $baris, $datalist->permasalahan);
                $baris++;
                $lcNo++;
            }

            $spreadsheet->getActiveSheet()->setTitle("usulan");
            $spreadsheet->createSheet();


            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            // header('Content-Type: text/csv');
            header('Content-Disposition: attachment; filename="usulan.xlsx"');

            // Set nama file excel nya    
            header('Cache-Control: max-age=0');
            // $writer = new Csv($spreadsheet);
            $writer = new Xlsx($spreadsheet);
            $writer->save('php://output');
            exit();
        }
    }

    public function cetakPublikasi()
    {
        $this->crudModel = new CrudModel();
        $dataListPublikasi = $this->crudModel->reportPublikasi();
        if ($dataListPublikasi) {
            $spreadsheet = new Spreadsheet();

            $spreadsheet->setActiveSheetIndex(0)->setCellValue("A1", "Publikasi Kajian");

            $spreadsheet->setActiveSheetIndex(0)->setCellValue("A2", "Tanggal : " . tanggal() . "/" . user()->nama);

            $spreadsheet->setActiveSheetIndex(0)->setCellValue("A3", "No");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("B3", "Judul Kajian");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("C3", "Perangkat Daerah");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("D3", "Bidang");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("E3", "Tahun");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("F3", "Keterangan");

            $baris = 4;
            $lcNo = 1;
            foreach ($dataListPublikasi as $datalist) {
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("A" . $baris, $lcNo);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("B" . $baris, $datalist->nama);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("C" . $baris, $datalist->pd);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("D" . $baris, $datalist->bidang);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("E" . $baris, $datalist->tahun);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("F" . $baris, $datalist->keterangan);

                $baris++;
                $lcNo++;
            }

            $spreadsheet->getActiveSheet()->setTitle("publikasi");
            $spreadsheet->createSheet();


            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            // header('Content-Type: text/csv');
            header('Content-Disposition: attachment; filename="publikasi.xlsx"');

            // Set nama file excel nya    
            header('Cache-Control: max-age=0');
            // $writer = new Csv($spreadsheet);
            $writer = new Xlsx($spreadsheet);
            $writer->save('php://output');
            exit();
        }
    }

    public function cetakMonitoring()
    {
        $this->crudModel = new CrudModel();
        $dataListPublikasi = $this->crudModel->reportMonitoring();
        if ($dataListPublikasi) {
            $spreadsheet = new Spreadsheet();

            $spreadsheet->setActiveSheetIndex(0)->setCellValue("A1", "Monitoring & Evaluasi");

            $spreadsheet->setActiveSheetIndex(0)->setCellValue("A2", "Tanggal : " . tanggal() . "/" . user()->nama);

            $spreadsheet->setActiveSheetIndex(0)->setCellValue("A3", "No");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("B3", "Judul Kajian");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("C3", "Perangkat Daerah");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("D3", "Bidang");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("E3", "Tahun");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("F3", "Keterangan");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("G3", "Kajian");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("H3", "Tahun Monev");
            $spreadsheet->setActiveSheetIndex(0)->setCellValue("I3", "Status");

            $baris = 4;
            $lcNo = 1;
            foreach ($dataListPublikasi as $datalist) {
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("A" . $baris, $lcNo);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("B" . $baris, $datalist->nama);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("C" . $baris, $datalist->pd);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("D" . $baris, $datalist->bidang);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("E" . $baris, $datalist->tahun);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("F" . $baris, $datalist->keterangan);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("G" . $baris, $datalist->kajian);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("H" . $baris, $datalist->tahub);
                $spreadsheet->setActiveSheetIndex(0)->setCellValue("I" . $baris, $datalist->id_status = 0 ? "Belum di proses" : $datalist->status);

                $baris++;
                $lcNo++;
            }

            $spreadsheet->getActiveSheet()->setTitle("monitoring");
            $spreadsheet->createSheet();


            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            // header('Content-Type: text/csv');
            header('Content-Disposition: attachment; filename="monitoring.xlsx"');

            // Set nama file excel nya    
            header('Cache-Control: max-age=0');
            // $writer = new Csv($spreadsheet);
            $writer = new Xlsx($spreadsheet);
            $writer->save('php://output');
            exit();
        }
    }
}
