<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\StatusModel;

class StatusController extends BaseController
{
    protected $statusModel;
    protected $title = "Status";
    protected $tabel = "status";
    protected $perPage = 10;
    public function  __construct()
    {
        $this->statusModel = new StatusModel();
        $this->data['title'] = $this->title;
        $this->data['tabel'] = $this->tabel;

        // $this->data['ls_status'] = $this->getStatus();
    }

    public function index($statusId = null)
    {
        $curentPage = $this->request->getVar('page') ? $this->request->getVar('page') : 1;
        $this->data['pages'] = $this->perPage * ($curentPage - 1);
        if ($statusId) {
            $status = $this->statusModel->find($statusId);
            if (!$status) {
                return redirect()->to($this->tabel);
            }

            $this->data['lcid'] = $status->id_status;
            $this->data['lcnama'] = $status->nama;

            // $this->data['lcstatus'] = $sma->status;
            // $this->data['lcquota'] = $sma->quota;


            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $this->getStatus();

        return view('pages/' . $this->tabel . '/list', $this->data);
    }

    private function getStatus()
    {
        // d($this->request->getVar('caridata'));
        $caridata = $this->request->getVar('caridata');
        if ($caridata) {
            $listData = $this->statusModel->caridata($caridata);
        } else {
            $listData = $this->statusModel->orderBy('nama', 'asc');
        }

        $this->data['listdata'] = $listData->paginate($this->perPage, $this->tabel);
        $this->data['pager'] = $listData->pager;
    }

    // menampilkan form input data 
    public function create()
    {
        return view('pages/' . $this->tabel . '/form', $this->data);
    }

    // menyimpan  data yg di input dari form
    public function store()
    {
        $nmTitle = 'Nama ' . $this->title;
        $rules = [
            'lcnama' => 'required|min_length[5]',
            // 'lcketerangan' => 'required|min_length[10]',


        ];
        $messages = [
            'lcnama' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5 Karakter',
            ],
            'lcketerangan' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => ' Panjang Keterangan Minimal 5 Karakter',
            ],

        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;

            $this->data['lcnama'] = $this->request->getVar('lcnama');
            // $this->data['lcketerangan'] = $this->request->getVar('lcketerangan');


            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $params = [
            'nama' => $this->request->getVar('lcnama'),
            // 'keterangan' => $this->request->getVar('lcketerangan'),

        ];
        if ($this->statusModel->save($params)) {
            return redirect()->to($this->tabel);
        }
    }

    // menrubah data yg di input dari form
    public function update($id)
    {
        $rules = [
            'lcnama' => 'required|min_length[5]',
            // 'lcketerangan' => 'required|min_length[10]',

        ];
        $messages = [
            'lcnama' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5 Karakter',
            ],
            // 'lcketerangan' => [
            //     'required' => 'Tidak boleh kosong',
            //     'min_length' => ' Panjang Keterangan Minimal 5 Karakter',
            // ],

        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;

            $this->data['lcid'] = $id;
            $this->data['lcnama'] = $this->request->getVar('lcnama');
            // $this->data['lcketerangan'] = $this->request->getVar('lcketerangan');;

            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $params = [
            'id_status' => $id,
            'nama' => $this->request->getVar('lcnama'),
            // 'keterangan' => $this->request->getVar('lcketerangan'),
            // 'status' => $this->request->getVar('lcstatus'),
            // 'quota' => $this->request->getVar('lcquota'),
        ];
        if ($this->statusModel->save($params)) {
            return redirect()->to($this->tabel);
        }
    }

    // hapus permanen dari tabel
    public function destroy($id)
    {
        $status = $this->statusModel->find($id);
        if (!$status) {
            return redirect()->to($this->tabel);
        }

        if ($this->statusModel->delete($status->id_status)) {
            return redirect()->to($this->tabel);
        }
    }

    // private function getStatus()
    // {
    //     $list['Negeri'] = 'Negeri';
    //     $list['Swasta'] = 'Swasta';
    //     return $list;
    // }
}
