<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Database\Migrations\Subpp;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\PrioritasModel;
use App\Models\SubppModel;
use App\Models\CrudModel;

class SubppController extends BaseController
{
    protected $prioritasModel;
    protected $subppModel;
    protected $crudModel;
    protected $title = "Sub Prioritas Pembangunan";
    protected $tabel = "subpp";
    protected $perPage = 10;
    public function  __construct()
    {
        $this->subppModel = new SubppModel();
        $this->prioritasModel = new PrioritasModel();
        // $this->crudModel = new CrudModel();
        $this->data['title'] = $this->title;
        $this->data['tabel'] = $this->tabel;
        $this->data['ls_prioritas'] = $this->getprioritas();
    }

    public function index($subppId = null)
    {
        $curentPage = $this->request->getVar('pages') ? $this->request->getVar('pages') : 1;
        $this->data['pages'] = $this->perPage * ($curentPage - 1);
        if ($subppId) {
            $subpp = $this->subppModel->find($subppId);
            if (!$subpp) {
                return redirect()->to($this->tabel);
            }

            $this->data['lcid'] = $subpp->id_subpp;
            $this->data['lcnama'] = $subpp->nama;
            $this->data['lcid_prioritas'] = $subpp->id_prioritas;
            // $this->data['lcketerangan'] = $bidang->keterangan;
            // $this->data['lcid_universitas'] = $fakultas->id_universitas;
            // $this->data['ls_pd'] = $this->getpd();
            // $this->data['lcquota'] = $sma->quota;
            // $this->data['ls_universitas'] = $this->getUniversitas();


            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $this->getSubpp();

        return view('pages/' . $this->tabel . '/list', $this->data);
    }

    private function getSubpp()
    {
        $this->crudModel = new CrudModel();
        $caridata = $this->request->getVar('caridata');
        if ($caridata) {
            $listData = $this->crudModel->getFindData('v_subpp', 'nama', $caridata);
        } else {
            $listData = $this->crudModel->getAllData('v_subpp', 'nama');
        }
        $this->data['listdata'] = $listData->paginate($this->perPage, $this->tabel);
        $this->data['pager'] = $listData->pager;
    }

    // menampilkan form input data 
    public function create()
    {
        return view('pages/' . $this->tabel . '/form', $this->data);
    }

    // menyimpan  data yg di input dari form
    public function store()
    {
        $nmTitle = 'Nama ' . $this->title;
        $rules = [
            'lcid_prioritas' => 'required|min_length[0]',
            // 'lcketerangan' => 'required|min_length[10]',
            // 'lcpd' => 'required',
            // 'lcquota' => 'required',

        ];
        $messages = [
            'lcnama' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],
            // 'lcketerangan' => [
            //     'required' => 'Tidak boleh kosong',
            //     'min_length' => ' Panjang Keterangan Minimal 5 Karakter',
            // ],
            'lcid_priorita' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => ' Harus Di pilih',
            ],
        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;
            $this->data['lcnama'] = $this->request->getVar('lcnama');
            // $this->data['lcketerangan'] = $this->request->getVar('lcketerangan');
            $this->data['lcid_prioritas'] = $this->request->getVar('lcid_prioritas');
            // $this->data['lcquota'] = $this->request->getVar('lcquota');

            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $params = [
            'nama' => $this->request->getVar('lcnama'),
            // 'keterangan' => $this->request->getVar('lcketerangan'),
            'id_prioritas' => $this->request->getVar('lcid_prioritas'),
            // 'quota' => $this->request->getVar('lcquota'),
        ];
        if ($this->subppModel->save($params)) {
            return redirect()->to($this->tabel);
        }
    }

    // menrubah data yg di input dari form
    public function update($id)
    {
        $nmTitle = 'Nama ' . $this->title;
        $rules = [
            'lcid_prioritas' => 'required|min_length[0]',
            // 'lcketerangan' => 'required|min_length[10]',
            // 'lcstatus' => 'required',
            // 'lcquota' => 'required|greater_than[0]',

        ];
        $messages = [
            'lcnama' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5 Karakter',
            ],
            // 'lcketerangan' => [
            //     'required' => 'Tidak boleh kosong',
            //     'min_length' => ' Panjang Keterangan Minimal 5 Karakter',
            // ],
            'lcid_prioritas' => [
                'required' => 'Tidak boleh kosong',
            ],
            // 'lcquota' => [
            //     'required' => 'Tidak boleh kosong',
            //     'greater_than' => 'mininal Quota 1',
            // ],
        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;

            $this->data['lcid'] = $id;
            $this->data['lcnama'] = $this->request->getVar('lcnama');
            // $this->data['lcketerangan'] = $this->request->getVar('lcketerangan');
            $this->data['lcid_prioritas'] = $this->request->getVar('lcid_prioritas');
            // $this->data['lcquota'] = $this->request->getVar('lcquota');

            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $params = [
            'id_subpp' => $id,
            'nama' => $this->request->getVar('lcnama'),
            // 'keterangan' => $this->request->getVar('lcketerangan'),
            'id_prioritas' => $this->request->getVar('lcid_prioritas'),
            // 'quota' => $this->request->getVar('lcquota'),
        ];
        if ($this->subppModel->save($params)) {
            return redirect()->to($this->tabel);
        }
    }

    // hapus permanen dari tabel
    public function destroy($id)
    {
        $subpp = $this->subppModel->find($id);
        if (!$subpp) {
            return redirect()->to($this->tabel);
        }

        if ($this->subppModel->delete($subpp->id_subpp)) {
            return redirect()->to($this->tabel);
        }
    }

    private function getPrioritas()
    {

        $list  = [
            0 => "Pilih Prioritas Pembangunan"
        ];
        if ($this->prioritasModel->countAllResults() > 0) {
            foreach ($this->prioritasModel->findAll() as $row) {
                $list[$row->id_prioritas] = $row->nama;
            }
        } else {
            $list  = [
                0 => "Tidak Ada Prioritas Pembangunan"
            ];
        }

        return $list;
    }

    public function getPilihSubPrio()
    {

        $lcId = $this->request->getVar('id');
        $lsDataList = $this->subppModel->listSubPrio($lcId)->get()->getResult();
        $ls_subpp = [
            0 => "Pilih Sub Prioritas Pembangunan"
        ];
        if ($lsDataList) {
            foreach ($lsDataList as $row) {
                $ls_subpp[$row->id_subpp] = $row->nama;
            }
        } else {
            $ls_subpp = [
                0 => "Tidak Ada Data"
            ];
        }

        return form_dropdown('lcid_subpp', $ls_subpp, isset($lcid_subpp) ? $lcid_subpp : '', 'class="form-control select2"');
    }
}
