<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\UrusanModel;

class UrusanController extends BaseController
{
    protected $urusanModel;
    protected $title = "Urusan";
    protected $tabel = "urusan";
    protected $perPage = 10;
    public function  __construct()
    {
        $this->urusanModel = new UrusanModel();
        $this->data['title'] = $this->title;
        $this->data['tabel'] = $this->tabel;

        // $this->data['ls_status'] = $this->getStatus();
    }

    public function index($urusanId = null)
    {
        $curentPage = $this->request->getVar('page') ? $this->request->getVar('page') : 1;
        $this->data['pages'] = $this->perPage * ($curentPage - 1);
        if ($urusanId) {
            $urusan = $this->urusanModel->find($urusanId);
            if (!$urusan) {
                return redirect()->to($this->tabel);
            }

            $this->data['lcid'] = $urusan->id_urusan;
            $this->data['lcnama'] = $urusan->nama;

            // $this->data['lcstatus'] = $sma->status;
            // $this->data['lcquota'] = $sma->quota;


            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $this->getUrusan();

        return view('pages/' . $this->tabel . '/list', $this->data);
    }

    private function getUrusan()
    {
        // d($this->request->getVar('caridata'));
        $caridata = $this->request->getVar('caridata');
        if ($caridata) {
            $listData = $this->urusanModel->caridata($caridata);
        } else {
            $listData = $this->urusanModel->orderBy('nama', 'asc');
        }

        $this->data['listdata'] = $listData->paginate($this->perPage, $this->tabel);
        $this->data['pager'] = $listData->pager;
    }

    // menampilkan form input data 
    public function create()
    {
        return view('pages/' . $this->tabel . '/form', $this->data);
    }

    // menyimpan  data yg di input dari form
    public function store()
    {
        $nmTitle = 'Nama ' . $this->title;
        $rules = [
            'lcnama' => 'required|min_length[5]',
            // 'lcketerangan' => 'required|min_length[10]',


        ];
        $messages = [
            'lcnama' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5 Karakter',
            ],
            'lcketerangan' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => ' Panjang Keterangan Minimal 5 Karakter',
            ],

        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;

            $this->data['lcnama'] = $this->request->getVar('lcnama');
            // $this->data['lcketerangan'] = $this->request->getVar('lcketerangan');


            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $params = [
            'nama' => $this->request->getVar('lcnama'),
            // 'keterangan' => $this->request->getVar('lcketerangan'),

        ];
        if ($this->urusanModel->save($params)) {
            return redirect()->to($this->tabel);
        }
    }

    // menrubah data yg di input dari form
    public function update($id)
    {
        $rules = [
            'lcnama' => 'required|min_length[5]',
            // 'lcketerangan' => 'required|min_length[10]',

        ];
        $messages = [
            'lcnama' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5 Karakter',
            ],
            // 'lcketerangan' => [
            //     'required' => 'Tidak boleh kosong',
            //     'min_length' => ' Panjang Keterangan Minimal 5 Karakter',
            // ],

        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;

            $this->data['lcid'] = $id;
            $this->data['lcnama'] = $this->request->getVar('lcnama');
            // $this->data['lcketerangan'] = $this->request->getVar('lcketerangan');;

            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $params = [
            'id_urusan' => $id,
            'nama' => $this->request->getVar('lcnama'),
            // 'keterangan' => $this->request->getVar('lcketerangan'),
            // 'status' => $this->request->getVar('lcstatus'),
            // 'quota' => $this->request->getVar('lcquota'),
        ];
        if ($this->urusanModel->save($params)) {
            return redirect()->to($this->tabel);
        }
    }

    // hapus permanen dari tabel
    public function destroy($id)
    {
        $urusan = $this->urusanModel->find($id);
        if (!$urusan) {
            return redirect()->to($this->tabel);
        }

        if ($this->urusanModel->delete($urusan->id_urusan)) {
            return redirect()->to($this->tabel);
        }
    }

    // private function getStatus()
    // {
    //     $list['Negeri'] = 'Negeri';
    //     $list['Swasta'] = 'Swasta';
    //     return $list;
    // }
}
