<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\UsersModel;
use Myth\Auth\Models\UserModel;
use Myth\Auth\Password;

class UsersController extends BaseController
{
    protected $usersModel;
    protected $title = "User Management";
    protected $tabel = "users";
    protected $perPage = 10;

    public function __construct()
    {
        $this->usersModel = new UsersModel();
        $this->data['title'] = $this->title;
        $this->data['tabel'] = $this->tabel;
        $this->data['ls_akses'] = $this->getRole();
    }

    public function index()
    {
        $curentPage = $this->request->getVar('page_users') ? $this->request->getVar('page_users') : 1;
        $this->data['pages'] = $this->perPage * ($curentPage - 1);
        $this->getUsers();
        return view('pages/' . $this->tabel . '/list', $this->data);
    }

    public function create()
    {
        $this->data['lcemail'] = "@";
        $this->data['lcpassword'] = "";
        $this->data['lcrepassword'] = "";
        return view('pages/' . $this->tabel . '/form', $this->data);
    }

    // menyimpan  data yg di input dari form
    public function store()
    {
        $rules = [
            'lcusername' => 'required|is_unique[users.username]|min_length[3]',
            'lcemail' => 'required|is_unique[users.email]|min_length[3]',
            'lcpassword'   => 'required|min_length[3]',
            'lcrepassword' => 'required|matches[lcpassword]',
            'lcnama' => 'required|min_length[4]',
            'lcid_akses' => 'required'
        ];
        $messages = [
            'lcusername' => [
                'required' => 'tidak boleh kosong',
                'is_unique' => 'sudah terdaftar',
                'min_length' => 'harus diatas 3 karakter',
            ],
            'lcemail' => [
                'required' => 'tidak boleh kosong',
                'is_unique' => 'sudah terdaftar',
                'min_length' => 'harus diatas 3 karakter',
            ],
            'lcpassword' => [
                'required' => 'tidak boleh kosong',
                'min_length' => 'harus diatas 3 karakter',
            ],
            'lcrepassword' => [
                'required' => 'tidak boleh kosong',
                'matches' => 'tidak sesaui dengan password',
            ],
            'lcnama' => [
                'required' => 'tidak boleh kosong',
                'min_length' => 'harus diatas 4 karakter',
            ],
            'lcid_akses' => [
                'required' => 'Hak akses harus dipilih',
            ],

        ];
        if (!$this->validate($rules, $messages)) {

            $this->data['validation'] = $this->validator;

            $this->data['lcusername'] = $this->request->getVar('lcusername');
            $this->data['lcemail'] = $this->request->getVar('lcemail');
            $this->data['lcnama'] = $this->request->getVar('lcnama');
            $this->data['lcid_akses'] = $this->request->getVar('lcid_akses');


            return view('pages/' . $this->tabel . '/form', $this->data);
            // return redirect()->to('/' . $this->tabel . '/createxxx')->withInput();
        }

        $params = [
            'username' => $this->request->getVar('lcusername'),
            'email' => $this->request->getVar('lcemail'),
            'password_hash' => Password::hash($this->request->getVar('lcpassword')),
            'active' => 1,
            'id_peserta' => 0,
            'nama' => $this->request->getVar('lcnama'),

        ];

        // dd($params);
        $user_Myth = new UserModel();
        if ($user_Myth->withGroup($this->request->getVar('lcid_akses'))->save($params)) {
            return redirect()->to($this->tabel);
        }
    }

    public function UbahPassword()
    {
        // dd(user_id());
        $this->data['lcid'] = user_id();

        return view('pages/' . $this->tabel . '/formedit', $this->data);
    }

    public function update()
    {
        $nmTitle = 'Nama ' . $this->title;

        $id = user_id();

        $rules = [

            'lcpasslama'   => 'required|min_length[3]|check_current_password[lcpasslama]',
            'lcpassbaru'   => 'required|min_length[3]',
            'lcrepass' => 'required|matches[lcpassbaru]',

        ];
        $messages = [

            'lcpasslama' => [
                'required' => 'tidak boleh kosong',
                'min_length' => 'harus diatas 3 karakter',
                'check_current_password' => 'password sebelumnya tidak sesuai',
            ],
            'lcpassbaru' => [
                'required' => 'tidak boleh kosong',
                'min_length' => 'harus diatas 3 karakter',
            ],
            'lcrepass' => [
                'required' => 'tidak boleh kosong',
                'matches' => 'tidak sesaui dengan password baru',
            ],

        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;

            return view('pages/' . $this->tabel . '/formedit', $this->data);
            // return redirect()->to('/' . $this->tabel . '/createxxx')->withInput();
        }

        $params = [
            'id' => $id,
            'password_hash' => Password::hash($this->request->getVar('lcpassbaru')),
        ];

        // dd($params);
        // $user_Myth = new UserModel();
        if ($this->usersModel->save($params)) {
            return redirect()->to('logout');
        }
    }

    private function getRole()
    {
        $roole  = ["" => "Pilih Hak Akses"];
        $roole["perserta"] = "Perangkat Daerah";
        $roole["admin"] = "Admin";
        // if ($this->aksesModel->countAllResults() > 0) {
        //     foreach ($this->aksesModel->findAll() as $row) {
        //         $roole[$row->name] = $row->name;
        //     }
        // } else {
        //     $roole  = [
        //         "" => "Tidak Ada Data Hak Akses"
        //     ];
        // }

        return $roole;
    }



    private function getUsers()
    {

        $caridata = $this->request->getVar('caridata');
        if ($caridata) {
            $listdata = $this->usersModel->caridata($caridata);
        } else {
            $listdata = $this->usersModel->orderBy('nama', 'asc');
        }

        $this->data['listdata'] = $listdata->paginate($this->perPage, $this->tabel);
        $this->data['pager'] = $listdata->pager;
    }
}
