<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Database\Migrations\Usulan;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\PdModel;
use App\Models\BidangModel;
use App\Models\PrioritasModel;
use App\Models\SubppModel;
use App\Models\UrusanModel;
use App\Models\UsulanModel;
use App\Models\StatusModel;
use App\Models\CrudModel;

class UsulanController extends BaseController
{
    protected $pdModel;
    protected $bidangModel;
    protected $prioritasModel;
    protected $subppModel;
    protected $urusanModel;
    protected $usulanModel;
    protected $statusModel;
    protected $crudModel;
    protected $title = " Usulan Kajian ";
    protected $tabel = "usulan";
    protected $perPage = 10;
    public function  __construct()
    {
        $this->usulanModel = new UsulanModel();
        $this->pdModel = new PdModel();
        $this->bidangModel = new BidangModel();
        $this->prioritasModel = new PrioritasModel();
        $this->subppModel = new SubppModel();
        $this->urusanModel = new UrusanModel();
        $this->statusModel = new StatusModel();
        $this->crudModel = new CrudModel();
        $this->data['title'] = $this->title;
        $this->data['tabel'] = $this->tabel;
        $this->data['ls_pd'] = $this->getpd();
        $this->data['ls_bidang'] =  [
            0 => "Tidak Ada Data  bidang"
        ];
        // $this->data['ls_bidang'] = $this->getbidang();

        $this->data['ls_prioritas'] = $this->getprioritas();
        $this->data['ls_subpp'] = [
            0 => "Pilih Sub Prioritas Pembangunan"
        ];
        // $this->data['ls_status'] = $this->getstatus();
        $this->data['ls_urusan'] = $this->geturusan();
        $this->data['ls_tahun'] = $this->getTahun();
    }

    public function index($usulanId = null)
    {
        $curentPage = $this->request->getVar('pages') ? $this->request->getVar('pages') : 1;
        $this->data['pages'] = $this->perPage * ($curentPage - 1);
        if ($usulanId) {
            $usulan = $this->usulanModel->find($usulanId);
            if (!$usulan) {
                return redirect()->to($this->tabel);
            }

            $this->data['ls_bidang']  = $this->getBidangbyidPD($usulanId);

            $this->data['lcid'] = $usulan->id_usulan;
            $this->data['lcid_pd'] = $usulan->id_pd;
            $this->data['lcid_bidang'] = $usulan->id_bidang;
            $this->data['lcid_prioritas'] = $usulan->id_prioritas;
            $this->data['lcid_subpp'] = $usulan->id_subpp;
            $this->data['lcid_urusan'] = $usulan->id_urusan;
            $this->data['lcnama'] = $usulan->nama;
            $this->data['lctahun'] = $usulan->tahun;
            $this->data['lclatarbelakang'] = $usulan->latarbelakang;
            $this->data['lcpermasalahan'] = $usulan->permasalahan;
            $this->data['lck'] = $usulan->kolaborasi;
            $this->data['lcdokumen'] = $usulan->dokumen;


            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $this->getUsulan();

        return view('pages/' . $this->tabel . '/list', $this->data);
    }

    private function getUsulan()
    {
        // d($this->request->getVar('caridata'));
        $this->crudModel = new CrudModel();
        $caridata = $this->request->getVar('caridata');
        if ($caridata) {
            $listData = $this->crudModel->cariDataUsulan($caridata);
        } else {
            $listData = $this->crudModel->allDataUsulan();
        }

        $this->data['listdata'] = $listData->paginate($this->perPage, 'v_usulan');
        $this->data['pager'] = $listData->pager;
    }

    public function create()
    {
        return view('pages/' . $this->tabel . '/form', $this->data);
    }

    // menyimpan  data yg di input dari form
    public function store()
    {
        $nmTitle = 'Nama ' . $this->title;
        $rules = [
            'lcid_pd' => 'required|greater_than[0]',
            'lcid_bidang' => 'required|greater_than[0]',
            'lcid_prioritas' => 'required|greater_than[0]',
            'lcid_subpp' => 'required|greater_than[0]',
            'lcid_urusan' => 'required|greater_than[0]',
            // 'lcid_status' => 'required|min_length[0]',
            'lctahun' => 'required|min_length[0]',
            'lcnama' => 'required|min_length[5]',
            'lclatarbelakang' => 'required|min_length[10]',
            'lcpermasalahan' => 'required|min_length[10]',

        ];
        $messages = [
            'lcnama' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],
            'lctahun' => [
                'required' => 'Tidak boleh kosong',

            ],
            'lclatarbelakang' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],
            'lcpermasalahan' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],
            'lcid_pd' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => '  Harus Di pilih',
            ],
            'lcid_bidang' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => ' Harus Di pilih',
            ],
            'lcid_prioritas' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => ' Harus Di pilih',
            ],
            'lcid_subpp' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => 'Harus Di pilih',
            ],

            'lcid_urusan' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => 'Harus Di pilih',
            ],

        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;
            $this->data['lcnama'] = $this->request->getVar('lcnama');
            $this->data['lctahun'] = $this->request->getVar('lctahun');
            $this->data['lclatarbelakang'] = $this->request->getVar('lclatarbelakang');
            $this->data['lcpermasalahan'] = $this->request->getVar('lcpermasalahan');
            $this->data['lcid_pd'] = $this->request->getVar('lcid_pd');
            $this->data['lcid_bidang'] = $this->request->getVar('lcid_bidang');
            $this->data['lcid_prioritas'] = $this->request->getVar('lcid_prioritas');
            $this->data['lcid_subpp'] = $this->request->getVar('lcid_subpp');
            $this->data['lcid_urusan'] = $this->request->getVar('lcid_urusan');

            return view('pages/' . $this->tabel . '/form', $this->data);
        };
        $params = [
            'nama' => $this->request->getVar('lcnama'),
            'tahun' => $this->request->getVar('lctahun'),
            'latarbelakang' => $this->request->getVar('lclatarbelakang'),
            'permasalahan' => $this->request->getVar('lcpermasalahan'),
            'id_pd' => $this->request->getVar('lcid_pd'),
            'id_bidang' => $this->request->getVar('lcid_bidang'),
            'id_prioritas' => $this->request->getVar('lcid_prioritas'),
            'id_subpp' => $this->request->getVar('lcid_subpp'),
            'id_urusan' => $this->request->getVar('lcid_urusan'),
        ];
        $lcDataLampiran  = $this->usulanModel->save($params);
        $lcDataId = $this->usulanModel->getInsertID();

        if ($lcDataLampiran) {
            $path = $_FILES['pdf']['name'];
            $lcNamaFile = substr($path, 0, strlen($path) - 4);
            $ext = pathinfo($path, PATHINFO_EXTENSION);
            $data_banner = $lcNamaFile . '_' . $lcDataId . '.' . $ext;
            $this->crudModel->file_pdf($lcNamaFile, "lampiran", $lcDataId, '', 'no', '.' . $ext);

            $params = [
                'id_usulan' => $lcDataId,
                'dokumen' => $data_banner,
            ];

            $this->usulanModel->save($params);

            // dd(substr($path, 0, strlen($path) - 4));
            return redirect()->to($this->tabel);
        }
        if ($this->usulanModel->save($params)) {
            return redirect()->to($this->tabel);
        }
    }

    // menrubah data yg di input dari form
    public function update($id)
    {
        // dd($this->request->getVar('lcid_prioritas'));
        // $this->data['lcid_subpp'] = $this->request->getVar('lcid_subpp');
        $rules = [
            'lcid_pd' => 'required|greater_than[0]',
            'lcid_bidang' => 'required|greater_than[0]',
            'lcid_prioritas' => 'required|greater_than[0]',
            'lcid_subpp' => 'required|greater_than[0]',
            'lcid_urusan' => 'required|greater_than[0]',
            'lclnama' => 'required|min_length[0]',
            'lcltahun' => 'required|min_length[0]',
            'lclatarbelakang' => 'required|min_length[5]',
            'lcpermasalahan' => 'required|min_length[5]',

        ];
        $messages = [
            'lcnama' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],
            'lctahun' => [
                'required' => 'Tidak boleh kosong',

            ],
            'lclatarbelakang' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],
            'lcpermasalahan' => [
                'required' => 'Tidak boleh kosong',
                'min_length' => 'Panjang Nama Minimal 5  Karakter',
            ],

            'lcid_pd' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => '  Harus Di pilih',
            ],
            'lcid_bidang' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => ' Harus Di pilih',
            ],
            'lcid_prioritas' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => ' Harus Di pilih',
            ],
            'lcid_subpp' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => 'Harus Di pilih',
            ],

            'lcid_urusan' => [
                'required' => 'Tidak boleh kosong',
                'greater_than' => 'Harus Di pilih',
            ],


        ];
        if (!$this->validate($rules, $messages)) {
            $this->data['validation'] = $this->validator;

            $this->data['lcid'] = $id;
            $this->data['lcnama'] = $this->request->getVar('lcnama');
            $this->data['lctahun'] = $this->request->getVar('lctahun');
            $this->data['lclatarbelakang'] = $this->request->getVar('lclatarbelakang');
            $this->data['lcpermasalahan'] = $this->request->getVar('lcpermasalahan');
            $this->data['lcid_pd'] = $this->request->getVar('lcid_pd');
            $this->data['lcid_bidang'] = $this->request->getVar('lcid_bidang');
            $this->data['lcid_prioritas'] = $this->request->getVar('lcid_prioritas');
            $this->data['lcid_subpp'] = $this->request->getVar('lcid_subpp');
            $this->data['lcid_urusan'] = $this->request->getVar('lcid_urusan');

            // dd($this->data);

            return view('pages/' . $this->tabel . '/form', $this->data);
        }

        $params = [
            'id_usulan' => $id,
            'nama' => $this->request->getVar('lcnama'),
            'tahun' => $this->request->getVar('lctahun'),
            'latarbelakang' => $this->request->getVar('lclatarbelakang'),
            'permasalahan' => $this->request->getVar('lcpermasalaha'),
            'id_pd' => $this->request->getVar('lcid_pd'),
            'id_bidang' => $this->request->getVar('lcid_bidang'),
            'id_prioritas' => $this->request->getVar('lcid_prioritas'),
            'id_subpp' => $this->request->getVar('lcid_subpp'),
            'id_urusan' => $this->request->getVar('lcid_urusan'),

        ];
        $lcDataLampiran  = $this->usulanModel->save($params);

        if ($lcDataLampiran) {
            $path = $_FILES['pdf']['name'];
            $lcNamaFile = substr($path, 0, strlen($path) - 4);
            $ext = pathinfo($path, PATHINFO_EXTENSION);
            $data_banner = $lcNamaFile . '_' . $id . '.' . $ext;
            $this->crudModel->file_pdf($lcNamaFile, "lampiran", $id, '', 'no', '.' . $ext);

            $params = [
                'id_usulan' => $id,
                'dokumen' => $data_banner,
            ];

            $this->usulanModel->save($params);

            return redirect()->to($this->tabel);
        }
    }

    // hapus permanen dari tabel
    public function destroy($id)
    {
        $usulan = $this->usulanModel->find($id);
        if (!$usulan) {
            return redirect()->to($this->tabel);
        }

        if ($this->usulanModel->delete($usulan->id_usulan)) {
            return redirect()->to($this->tabel);
        }
    }

    private function getPd()
    {
        $pd = [
            0 => "Pilih PD"
        ];
        if ($this->pdModel->countAllResults() > 0) {
            foreach ($this->pdModel->findAll() as $row) {
                $pd[$row->id_pd] = $row->nama;
            }
        } else {
            $pd  = [
                0 => "Tidak Ada PD"
            ];
        }

        return $pd;
    }


    public function getPilihBidang()
    {
        $lcKode = $this->request->getVar('pd');
        $lsDataList = $this->bidangModel->listBidang($lcKode)->get()->getResult();
        $ls_bidang = [
            0 => "Pilih Bidang"
        ];
        if ($lsDataList) {
            foreach ($lsDataList as $row) {
                $ls_bidang[$row->kode] = $row->nama;
            }
        } else {
            $ls_bidang = [
                0 => "Tidak Ada Data "
            ];
        }

        return form_dropdown('lcid_bidang', $ls_bidang, isset($lcid_bidang) ? $lcid_bidang : '', 'class="form-control select2"');
    }

    private function getPrioritas()
    {

        $list  = [
            0 => "Pilih Prioritas Pembangunan"
        ];
        if ($this->prioritasModel->countAllResults() > 0) {
            foreach ($this->prioritasModel->findAll() as $row) {
                $list[$row->id_prioritas] = $row->nama;
            }
        } else {
            $list  = [
                0 => "Tidak Ada  Data"
            ];
        }

        return $list;
    }
    private function getSubpp()
    {

        $list  = [
            0 => "Pilih Sub Prioritas Pembangunan"
        ];
        if ($this->subppModel->countAllResults() > 0) {
            foreach ($this->subppModel->findAll() as $row) {
                $list[$row->id_subpp] = $row->nama;
            }
        } else {
            $list  = [
                0 => "Tidak Ada  Data"
            ];
        }

        return $list;
    }
    private function getUrusan()
    {

        $list  = [
            0 => "Pilih Urusan"
        ];
        if ($this->urusanModel->countAllResults() > 0) {
            foreach ($this->urusanModel->findAll() as $row) {
                $list[$row->id_urusan] = $row->nama;
            }
        } else {
            $list  = [
                0 => "Tidak Ada  Data"
            ];
        }

        return $list;
    }
    // private function getStatus()
    // {

    //     $list  = [
    //         0 => "Pilih Disposisi"
    //     ];
    //     if ($this->statusModel->countAllResults() > 0) {
    //         foreach ($this->statusModel->findAll() as $row) {
    //             $list[$row->id_status] = $row->nama;
    //         }
    //     } else {
    //         $list  = [
    //             0 => "Tidak Ada  Data"
    //         ];
    //     }

    //     return $list;
    // }
    private function getTahun()
    {
        $list['2021'] = '2021';
        $list['2022'] = '2022';
        $list['2023'] = '2023';
        $list['2024'] = '2024';
        $list['2025'] = '2025';
        $list['2026'] = '2026';
        $list['2027'] = '2027';
        $list['2028'] = '2028';
        $list['2029'] = '2029';
        $list['2030'] = '2030';
        return $list;
    }


    private function getBidangbyidPD($idPD)
    {

        $list  = [
            0 => "Pilih Bidang"
        ];
        $lcData = $this->crudModel->getBidanbyidPD($idPD);
        if ($lcData) {
            foreach ($lcData as $row) {
                $list[$row->id_bidang] = $row->nama;
            }
        } else {
            $list  = [
                0 => "Tidak Ada  Data"
            ];
        }

        return $list;
    }
}
