<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Sma extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id_sma' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'nama' => [
                'type'       => 'VARCHAR',
                'constraint' => 100,
                'null'       => false,
            ],
            'alamat' => [
                'type'       => 'VARCHAR',
                'constraint' => 225,
                'null'       => true,
            ],
            'status' => [
                'type'       => 'VARCHAR',
                'constraint' => 10,
                'null'       => true,
            ],
            'quota' => [
                'type'       => 'INT',
                'constraint' => 3,
                'null'       => true,
            ],
            'deleted_at' => [
                'type'       => 'DATETIME',
            ],
            'created_at' => [
                'type'       => 'DATETIME',
            ],
            'updated_at' => [
                'type' => 'DATETIME',
            ],
            'created_id' => [
                'type'       => 'INT',
                'constraint' => 11,
            ],
            'updated_id' => [
                'type' => 'INT',
                'constraint' => 11,
            ],

        ]);
        $this->forge->addKey('id_sma', true);
        $this->forge->createTable('sma');
    }

    public function down()
    {
        $this->forge->dropTable('sma');
    }
}
