<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Peserta extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id_peserta' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'nama' => [
                'type'       => 'VARCHAR',
                'constraint' => 100,
                'null'       => false,
            ],
            'alamat' => [
                'type'       => 'VARCHAR',
                'constraint' => 225,
                'null'       => true,
            ],
            'id_kecamatan' => [
                'type'           => 'INT',
                'constraint'     => 11,
            ],
            'id_kelurahan' => [
                'type'           => 'INT',
                'constraint'     => 11,
            ],
            'noktp' => [
                'type'       => 'VARCHAR',
                'constraint' => 16,
            ],
            'id_sekolah' => [
                'type'       => 'INT',
                'constraint' => 11,
            ],
            'id_universitas' => [
                'type'       => 'INT',
                'constraint' => 11,
            ],
            'status' => [
                'type'       => 'VARCHAR',
                'constraint' => 2,
            ],
            'kategori' => [
                'type'       => 'VARCHAR',
                'constraint' => 2,
            ],
            'deleted_at' => [
                'type'       => 'DATETIME',
            ],
            'created_at' => [
                'type'       => 'DATETIME',
            ],
            'updated_at' => [
                'type' => 'DATETIME',
            ],
            'created_id' => [
                'type'       => 'INT',
                'constraint' => 11,
            ],
            'updated_id' => [
                'type' => 'INT',
                'constraint' => 11,
            ],

        ]);
        $this->forge->addKey('id_peserta', true);
        $this->forge->createTable('peserta');
    }

    public function down()
    {
        $this->forge->dropTable('peserta');
    }
}
