<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Lampiran extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id_lampiran' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'nama' => [
                'type'       => 'VARCHAR',
                'constraint' => 100,
                'null'       => false,
            ],
            'keteranagan' => [
                'type'       => 'VARCHAR',
                'constraint' => 225,
                'null'       => true,
            ],
            'lampiran' => [
                'type'       => 'VARCHAR',
                'constraint' => 200,
                'null'       => false,
            ],
            'jenis' => [
                'type'       => 'VARCHAR',
                'constraint' => 1,
                'null'       => false,
            ],
            'id_peserta' => [
                'type'           => 'INT',
                'constraint'     => 11,
            ],
            'deleted_at' => [
                'type'       => 'DATETIME',
            ],
            'created_at' => [
                'type'       => 'DATETIME',
            ],
            'updated_at' => [
                'type' => 'DATETIME',
            ],
            'created_id' => [
                'type'       => 'INT',
                'constraint' => 11,
            ],
            'updated_id' => [
                'type' => 'INT',
                'constraint' => 11,
            ],

        ]);
        $this->forge->addKey('id_lampiran', true);
        $this->forge->createTable('lampiran');
    }

    public function down()
    {
        $this->forge->dropTable('lampiran');
    }
}
