<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Skore extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id_skore' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'id_peserta' => [
                'type'       => 'INT',
                'constraint' => 11,
                'null'       => false,
            ],
            'id_user' => [
                'type'       => 'INT',
                'constraint' => 11,
                'null'       => false,
            ],
            'namapenilai' => [
                'type'       => 'VARCHAR',
                'constraint' => 200,
            ],
            'catatan' => [
                'type'       => 'VARCHAR',
                'constraint' => 225,
                'null'       => true,
            ],
            'score' => [
                'type'       => 'INT',
                'constraint' => 11,
            ],
            'deleted_at' => [
                'type'       => 'DATETIME',
            ],
            'created_at' => [
                'type'       => 'DATETIME',
            ],
            'updated_at' => [
                'type' => 'DATETIME',
            ],
            'created_id' => [
                'type'       => 'INT',
                'constraint' => 11,
            ],
            'updated_id' => [
                'type' => 'INT',
                'constraint' => 11,
            ],

        ]);
        $this->forge->addKey('id_skore', true);
        $this->forge->createTable('skore');
    }

    public function down()
    {
        $this->forge->dropTable('skore');
    }
}
