<?php

/**
 * Helpher untuk mencetak tanggal dalam format bahasa indonesia
 *
 * @package CodeIgniter
 * @category Helpers
 * @author Ardianta Pargo (ardianta_pargo@yhaoo.co.id)
 * @link https://gist.github.com/ardianta/ba0934a0ee88315359d30095c7e442de
 * @version 1.0
 */

/**
 * Fungsi untuk merubah bulan bahasa inggris menjadi bahasa indonesia
 * @param int nomer bulan, Date('m')
 * @return string nama bulan dalam bahasa indonesia
 */
if (!function_exists('bulan')) {
    function bulan()
    {
        $bulan = Date('m');
        switch ($bulan) {
            case 1:
                $bulan = "Januari";
                break;
            case 2:
                $bulan = "Februari";
                break;
            case 3:
                $bulan = "Maret";
                break;
            case 4:
                $bulan = "April";
                break;
            case 5:
                $bulan = "Mei";
                break;
            case 6:
                $bulan = "Juni";
                break;
            case 7:
                $bulan = "Juli";
                break;
            case 8:
                $bulan = "Agustus";
                break;
            case 9:
                $bulan = "September";
                break;
            case 10:
                $bulan = "Oktober";
                break;
            case 11:
                $bulan = "November";
                break;
            case 12:
                $bulan = "Desember";
                break;

            default:
                $bulan = Date('F');
                break;
        }
        return $bulan;
    }
}

/**
 * Fungsi untuk membuat tanggal dalam format bahasa indonesia
 * @param void
 * @return string format tanggal sekarang (contoh: 22 Desember 2016)
 */
if (!function_exists('tanggal')) {
    function tanggal()
    {
        $tanggal = Date('d') . " " . bulan() . " " . Date('Y');
        return $tanggal;
    }
}

if (!function_exists('bulanlain')) {
    function bulanlain($bulan)
    {
        switch ($bulan) {
            case 1:
                $bulan = "Januari";
                break;
            case 2:
                $bulan = "Februari";
                break;
            case 3:
                $bulan = "Maret";
                break;
            case 4:
                $bulan = "April";
                break;
            case 5:
                $bulan = "Mei";
                break;
            case 6:
                $bulan = "Juni";
                break;
            case 7:
                $bulan = "Juli";
                break;
            case 8:
                $bulan = "Agustus";
                break;
            case 9:
                $bulan = "September";
                break;
            case 10:
                $bulan = "Oktober";
                break;
            case 11:
                $bulan = "November";
                break;
            case 12:
                $bulan = "Desember";
                break;

            default:
                $bulan = Date('F');
                break;
        }
        return $bulan;
    }
}

if (!function_exists('tgllain')) {
    function tgllain($hari, $tgl)
    {
        if ($hari == 1) {
            $tanggal = Date('d', strtotime($tgl)) . " " . bulanlain(Date('m', strtotime($tgl))) . " " . Date('Y', strtotime($tgl));
            return $tanggal;
        }
        if ($hari == 2) {
            $tanggal1 = Date('d', strtotime($tgl)) . " " . bulanlain(Date('m', strtotime($tgl))) . " " . Date('Y', strtotime($tgl));
            $tanggal2 = Date('d', strtotime($tgl . " +1 day")) . " " . bulanlain(Date('m', strtotime($tgl . " +1 day"))) . " " . Date('Y', strtotime($tgl . " +1 day"));
            $tanggal = $tanggal1 . " s/d " . $tanggal2;
            return $tanggal;
        }

        if ($hari > 2) {
            $tanggal1 = Date('d', strtotime($tgl)) . " " . bulanlain(Date('m', strtotime($tgl))) . " " . Date('Y', strtotime($tgl));
            $tanggal2 = Date('d', strtotime($tgl . " +" . $hari - 1 . "day")) . " " . bulanlain(Date('m', strtotime($tgl . " +" . $hari - 1 . "day"))) . " " . Date('Y', strtotime($tgl . " +" . $hari - 1 . "day"));
            $tanggal = $tanggal1 . " s/d " . $tanggal2;
            return $tanggal;
        }


        // $tglArray = explode("-", $tgl);
        // $tanggal = $tglArray[0] . " " . bulanlain($tglArray[1]) . " " . $tglArray[2];
        // return $tanggal;
    }
}

if (!function_exists('hariIndo')) {
    function hariIndo($hariInggris)
    {
        switch ($hariInggris) {
            case 'Sunday':
                return 'Minggu';
            case 'Monday':
                return 'Senin';
            case 'Tuesday':
                return 'Selasa';
            case 'Wednesday':
                return 'Rabu';
            case 'Thursday':
                return 'Kamis';
            case 'Friday':
                return 'Jumat';
            case 'Saturday':
                return 'Sabtu';
            default:
                return 'hari tidak valid';
        }
    }
}

if (!function_exists('namahari')) {
    function namahari($hari, $tgl)
    {
        if ($hari == 1) {
            return hariIndo(Date('l', strtotime($tgl)));
        }
        if ($hari == 2) {
            $hari1 = hariIndo(Date('l', strtotime($tgl)));
            $hari2 = hariIndo(Date('l', strtotime($tgl . " +1 day")));
            return $hari1 . " s/d " . $hari2;
        }
        if ($hari > 2) {
            $hari1 = hariIndo(Date('l', strtotime($tgl)));
            $hari2 = hariIndo(Date('l', strtotime($tgl . " +" . $hari - 1 . "day")));
            return $hari1 . " s/d " . $hari2;
        }
    }
}

if (!function_exists('tglakhir')) {
    function tglakhir($hari, $tgl)
    {
        if ($hari == 1) {
            $tanggal = Date('d', strtotime($tgl)) . " " . bulanlain(Date('m', strtotime($tgl))) . " " . Date('Y', strtotime($tgl));
            return $tanggal;
        } else {
            $tanggal2 = Date('d', strtotime($tgl . " +" . $hari - 1 . "day")) . " " . bulanlain(Date('m', strtotime($tgl . " +" . $hari - 1 . "day"))) . " " . Date('Y', strtotime($tgl . " +" . $hari - 1 . "day"));
            $tanggal = $tanggal2;
            return $tanggal;
        }
    }
}

if (!function_exists('tglcsv')) {
    function tglcsv()
    {
        $tanggal = Date('Y') . "" . Date('m') . "" . Date('d');
        return $tanggal;
    }
}
