<?php

namespace App\Models;

use CodeIgniter\Model;

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Crudmodel
 *
 * @author Machfudh
 */
class CrudModel extends Model
{

    protected $table;
    protected $returnType = 'object';

    function clear_cache()
    {
        $this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
        $this->output->set_header('Pragma: no-cache');
    }

    public function getListDok($tabelView, $caridata)
    {
        $this->table = $tabelView;

        $query = $this->table($tabelView)
            ->where('key', $caridata);
        return $query;
    }

    public function getFindData($tabelView, $orderView, $caridata)
    {
        $this->table = $tabelView;

        $query = $this->table($tabelView)
            ->like('nama', $caridata)
            ->orderBy($orderView, 'ASC');
        return $query;
    }

    public function getAllData($tabelView, $orderView)
    {
        $this->table = $tabelView;

        $query = $this->table($tabelView)
            ->orderBy($orderView, 'ASC');
        return $query;
    }

    // FILE_UPLOAD
    function img_thumb($type, $id, $ext = '.jpg', $width = '400', $height = '400')
    {
        $this->load->library('image_lib');
        ini_set("memory_limit", "-1");

        $config1['image_library'] = 'gd2';
        $config1['create_thumb'] = TRUE;
        $config1['maintain_ratio'] = TRUE;
        $config1['width'] = $width;
        $config1['height'] = $height;
        $config1['source_image'] = 'uploads/' . $type . '_image/' . $type . '_' . $id . $ext;

        $this->image_lib->initialize($config1);
        $this->image_lib->resize();
        $this->image_lib->clear();
    }
    // FILE_UPLOAD
    function file_pdf($name, $type, $id, $multi = '', $no_thumb = '', $ext = '.pdf')
    {
        $timeinsert = time();
        if ($multi == '') {
            //            move_uploaded_file($_FILES[$name]['tmp_name'], 'uploads/' . $type . $ext);
            move_uploaded_file($_FILES['pdf']['tmp_name'], 'uploads/' . $type . '_pdf/' . $name . '_' . $id . $ext);
            if ($no_thumb == '') {
                $this->crudmodel->img_thumb($type, $id, $ext);
            }
        } elseif ($multi == 'multi') {
            $ib = 1;
            foreach ($_FILES[$name]['name'] as $i => $row) {
                $ib = $this->file_exist_ret($type, $id, $ib);
                //                move_uploaded_file($_FILES[$name]['tmp_name'][$i], 'uploads/' . $type . '_data/' . $type . '_' . $id . '_' . $ib . $ext);
                move_uploaded_file($_FILES[$name]['tmp_name'][$i], 'uploads/' . $type . '_pdf/' . $name . '_' . $id . '_' . $ib . $ext);
                if ($no_thumb == '') {
                    $this->crudmodel->img_thumb($type, $id . '_' . $ib, $ext);
                }
            }
        }
    }

    // FILE_UPLOAD
    function file_txt($name, $type, $id, $multi = '', $no_thumb = '', $ext = '.txt')
    {
        $timeinsert = time();
        if ($multi == '') {
            move_uploaded_file($_FILES[$name]['tmp_name'], 'uploads/barang_data/' . $type . $ext);
            if ($no_thumb == '') {
                $this->crudmodel->img_thumb($type, $id, $ext);
            }
        } elseif ($multi == 'multi') {
            $ib = 1;
            foreach ($_FILES[$name]['name'] as $i => $row) {
                $ib = $this->file_exist_ret($type, $id, $ib);
                move_uploaded_file($_FILES[$name]['tmp_name'][$i], 'uploads/' . $type . '_data/' . $type . '_' . $id . '_' . $ib . $ext);
                if ($no_thumb == '') {
                    $this->crudmodel->img_thumb($type, $id . '_' . $ib, $ext);
                }
            }
        }
    }

    // FILE_UPLOAD
    function file_up($name, $type, $id, $multi = '', $no_thumb = '', $ext = '.jpg')
    {
        if ($multi == '') {
            move_uploaded_file($_FILES['image']['tmp_name'], 'uploads/' . $type . '_image/' . $name . '_' . $id . $ext);
            if ($no_thumb == '') {
                $this->crudmodel->img_thumb($type, $id, $ext);
            }
        } elseif ($multi == 'multi') {
            $ib = 1;
            foreach ($_FILES[$name]['name'] as $i => $row) {
                $ib = $this->file_exist_ret($type, $id, $ib);
                move_uploaded_file($_FILES[$name]['tmp_name'][$i], 'uploads/' . $type . '_image/' . $name . '_' . $id . '_' . $ib . $ext);
                if ($no_thumb == '') {
                    $this->crudmodel->img_thumb($type, $id . '_' . $ib, $ext);
                }
            }
        }
    }

    // FILE_UPLOAD
    function file_uprisize($name, $type, $id, $multi = '', $no_thumb = '', $ext = '.jpg')
    {
        if ($multi == '') {
            //            move_uploaded_file($_FILES[$name]['tmp_name'], 'uploads/' . $type . '_image/' . $name . '_' . $id . $ext);
            $folder = 'uploads/' . $type . '_image/';
            $upload_image = $_FILES[$name]['name'];
            $width_size = 480;
            // tentukan di mana image akan ditempatkan setelah diupload
            $filesave = $folder . $upload_image;
            move_uploaded_file($_FILES[$name]['tmp_name'], $filesave);

            // menentukan nama image setelah dibuat
            $resize_image = $folder .  $name . '_' . $id . $ext;

            // mendapatkan ukuran width dan height dari image
            list($width, $height) = getimagesize($filesave);

            // mendapatkan nilai pembagi supaya ukuran skala image yang dihasilkan sesuai dengan aslinya
            $k = $width / $width_size;

            // menentukan width yang baru
            $newwidth = $width / $k;

            // menentukan height yang baru
            $newheight = $height / $k;

            // fungsi untuk membuat image yang baru
            $thumb = imagecreatetruecolor($newwidth, $newheight);
            $source = imagecreatefromjpeg($filesave);

            // men-resize image yang baru
            imagecopyresized($thumb, $source, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);

            // menyimpan image yang baru
            imagejpeg($thumb, $resize_image);

            imagedestroy($thumb);
            imagedestroy($source);
        } elseif ($multi == 'multi') {
            $ib = 1;
            foreach ($_FILES[$name]['name'] as $i => $row) {
                $ib = $this->file_exist_ret($type, $id, $ib);
                move_uploaded_file($_FILES[$name]['tmp_name'][$i], 'uploads/' . $type . '_image/' . $name . '_' . $id . '_' . $ib . $ext);
                if ($no_thumb == '') {
                    $this->crudmodel->img_thumb($type, $id . '_' . $ib, $ext);
                }
            }
        }
    }

    public function dataSeleksiAwal($caridata)
    {
        $this->table = 'v_seleksiawal';

        $query = $this->table('v_seleksiawal')
            ->like('nama', $caridata)
            ->orderBy('nama', 'ASC');
        return $query;
    }

    public function dataSeleksiAwalAll()
    {
        $this->table = 'v_seleksiawal';

        $query = $this->table('v_seleksiawal')
            ->orderBy('nama', 'ASC');
        return $query;
    }

    public function dataDaftarAll()
    {
        $this->table = 'peserta';

        $query = $this->table('peserta')
            ->where('status', "0")
            ->orderBy('nama', 'ASC');
        return $query;
    }

    public function dataSeleksiAkhir($caridata)
    {
        $this->table = 'v_seleksiakhir';

        $query = $this->table('v_seleksiakhir')
            ->like('nama', $caridata)
            ->orderBy('nama', 'ASC');
        return $query;
    }

    public function dataSeleksiAkhirAll()
    {
        $this->table = 'v_seleksiakhir';

        $query = $this->table('v_seleksiakhir')
            ->orderBy('nama', 'ASC');
        return $query;
    }

    public function dataLolosSeleksi($caridata)
    {
        $this->table = 'v_seleksilolos';

        $query = $this->table('v_seleksilolos')
            ->like('nama', $caridata)
            ->orderBy('nama', 'ASC');
        return $query;
    }

    public function dataLolosSeleksiAll()
    {
        $this->table = 'v_seleksilolos';

        $query = $this->table('v_seleksilolos')
            ->orderBy('nama', 'ASC');
        return $query;
    }


    public function cariDataUsulan($caridata)
    {
        $this->table = 'v_usulan';

        $query = $this->table('v_usulan')
            ->orderBy('nama', 'ASC');
        return $query;
    }

    public function allDataUsulan()
    {
        $this->table = 'v_usulan';

        $query = $this->table('v_usulan')
            ->orderBy('nama', 'ASC');
        return $query;
    }
    public function allDataPublikasi()
    {
        $this->table = 'v_publikasi';

        $query = $this->table('v_publikasi')
            ->orderBy('nama', 'ASC');
        return $query;
    }
    public function allDataDisposisi()
    {
        $this->table = 'v_usulan';

        $query = $this->table('v_usulan')
            ->orderBy('nama', 'ASC');
        return $query;
    }

    public function allDataKolab($idUsulan)
    {
        $this->table = 'kolaborasi';

        $query = $this->table('kolaborasi')
            ->orderBy('id_usulan', 'asc')
            ->where('id_usulan', $idUsulan);
        return $query;
    }

    public function cariDataKolab($idUsulan, $caridata)
    {
        $this->table = 'kolaborasi';
        $query = $this->table('kolaborasi')
            ->orderBy('id_usulan', 'asc')
            ->where('id_usulan', $idUsulan);
        return $query;
    }


    public function getBidanbyidPD($idPD)
    {
        $this->table = 'bidang';
        $query = $this->table('bidang')
            ->orderBy('id_bidang', 'asc')
            ->where('id_pd', $idPD)
            ->get()->getResult();
        return $query;
    }

    public function reportUsulan()
    {
        $this->table = 'v_usulan';
        $query = $this->table('v_usulan')
            ->orderBy('pd', 'asc')
            ->get()->getResult();
        return $query;
    }

    public function reportPublikasi()
    {
        $this->table = 'v_publikasi';
        $query = $this->table('v_publikasi')
            ->orderBy('nama', 'asc')
            ->get()->getResult();
        return $query;
    }

    public function reportMonitoring()
    {
        $this->table = 'v_publikasi';
        $query = $this->table('v_publikasi')
            ->orderBy('nama', 'asc')
            ->get()->getResult();
        return $query;
    }
}
