<?php

namespace App\Models;

use CodeIgniter\Model;

class KolaborasiModel extends Model
{
    protected $table            = 'kolaborasi';
    protected $primaryKey       = 'id_kolaborasi';
    protected $useAutoIncrement = true;
    protected $returnType       = 'App\Entities\KolaborasiEntity';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['id_kolaborasi', 'id_usulan', 'id_pd', 'id_bidang', 'keterangan'];

    protected bool $allowEmptyInserts = false;

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    private $tableQuery = 'v_kolaborasi';

    public function allData($idUsulan)
    {
        return $this->table($this->tableQuery)
            ->orderBy('id_usulan', 'asc')
            ->where('id_usulan', $idUsulan);
		
    }

    public function cariData($idUsulan, $caridata)
    {
        return $this->table($this->tableQuery)
            ->orderBy('id_usulan', 'asc')
            ->where('id_usulan', $idUsulan);
    }
	

}
