<?php

namespace App\Models;

use CodeIgniter\Model;

class PdModel extends Model
{
    protected $table            = 'pd';
    protected $primaryKey       = 'id_pd';
    protected $useAutoIncrement = true;
    protected $returnType       = 'App\Entities\PdEntity';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    =  ['nama'];

    protected bool $allowEmptyInserts = false;

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;


    private $tableQuery = 'pd';


    public function caridata($caridata)
    {
        return $this->table($this->tableQuery)->orderBy('nama', 'asc')->like('nama', $caridata);
    }
}
