<?php

namespace App\Models;

use CodeIgniter\Model;

class PublikasiModel extends Model
{
    protected $table            = 'publikasi';
    protected $primaryKey       = 'id_publikasi';
    protected $useAutoIncrement = true;
    protected $returnType       = 'App\Entities\PublikasiEntity';
    protected $useSoftDeletes   = false;
    // protected $protectFields    = true;
    protected $allowedFields    = ['id_publikasi', 'id_pd', 'id_bidang', 'tahun', 'nama', 'keterangan', 'image', 'dokumen', 'kajian', 'tahub', 'id_status'];

    // protected bool $allowEmptyInserts = false;

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    private $tableQuery = 'v_publikasi';
    public function caridata($caridata)
    {
        return $this->table($this->tableQuery)->orderBy('nama', 'asc')->like('nama', $caridata);
    }

    public function alldata()
    {
        return $this->table($this->tableQuery)->orderBy('nama', 'asc');
    }

    // public function caridata($caridata)
    // {
    //     if ($caridata == "") {
    //         return $this->table($this->tableQuery)
    //             ->select('fakultas.id_fakultas', 'fakultas.nama', 'fakultas.keterangan', 'universitas.nama as universitas')
    //             ->join('universitas', 'fakultas.id_universitas = universitas.id_universitas', 'left')
    //             ->orderBy('fakultas.nama', 'ASC');
    //     } else {
    //         return $this->table($this->tableQuery)
    //             ->select('fakultas.id_fakultas', 'fakultas.nama', 'fakultas.keterangan', 'universitas.nama as universitas')
    //             ->join('universitas', 'fakultas.id_universitas = universitas.id_universitas')
    //             ->orderBy('fakultas.nama', 'ASC')->like('fakultas.nama', $caridata);
    //     }
    // }


}
