<?php

namespace App\Models;

use CodeIgniter\Model;

class SubppModel extends Model
{
    protected $table            = 'subpp';
    protected $primaryKey       = 'id_subpp';
    protected $useAutoIncrement = true;
    protected $returnType       = 'App\Entities\SubppEntity';
    protected $useSoftDeletes   = false;
    // protected $protectFields    = true;
    protected $allowedFields    = ['id_subpp', 'nama', 'keterangan', 'id_prioritas'];

    // protected bool $allowEmptyInserts = false;

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    private $tableQuery = 'v_subpp';

    // public function caridata($caridata)
    // {
    //     if ($caridata == "") {
    //         return $this->table($this->tableQuery)
    //             ->select('fakultas.id_fakultas', 'fakultas.nama', 'fakultas.keterangan', 'universitas.nama as universitas')
    //             ->join('universitas', 'fakultas.id_universitas = universitas.id_universitas', 'left')
    //             ->orderBy('fakultas.nama', 'ASC');
    //     } else {
    //         return $this->table($this->tableQuery)
    //             ->select('fakultas.id_fakultas', 'fakultas.nama', 'fakultas.keterangan', 'universitas.nama as universitas')
    //             ->join('universitas', 'fakultas.id_universitas = universitas.id_universitas')
    //             ->orderBy('fakultas.nama', 'ASC')->like('fakultas.nama', $caridata);
    //     }
    // }

    public function caridata($caridata)
    {
        return $this->table($this->tableQuery)->orderBy('nama', 'asc')->like('nama', $caridata);
    }

    public function listSubPrio($idPd)
    {
        return $this->table($this->table)
            ->orderBy('nama', 'ASC')
            ->where('id_prioritas', $idPd);
    }
}
