<?php

namespace App\Validation;

use App\Models\UsersModel;

class IsCurrentPasswordCorrect
{
    protected $usersModel;

    public function check_current_password($password): bool
    {

        $this->usersModel = new UsersModel();
        $lcPassword = trim($password);
        $user_id = user_id();
        $lcUserInfo = $this->usersModel->find($user_id);
        if (!password_verify(base64_encode(hash('sha384', $lcPassword, true)), $lcUserInfo->password_hash)) {
            return false;
        }
        return true;
    }
}
