# Changelog

## [v1.2.0](https://github.com/lonnieezell/myth-auth/tree/v1.2.0) (2022-07-13)

[Full Changelog](https://github.com/lonnieezell/myth-auth/compare/v1.1.0...v1.2.0)

**Merged pull requests:**

- Alternate Models [\#545](https://github.com/lonnieezell/myth-auth/pull/545) ([MGatner](https://github.com/MGatner))

## [v1.1.0](https://github.com/lonnieezell/myth-auth/tree/v1.1.0) (2022-07-13)

[Full Changelog](https://github.com/lonnieezell/myth-auth/compare/v1.0.1...v1.1.0)

**Implemented enhancements:**

- Add username validation rules [\#248](https://github.com/lonnieezell/myth-auth/issues/248)
- Deactivated user [\#241](https://github.com/lonnieezell/myth-auth/issues/241)

**Fixed bugs:**

- The Auth Trait's restrictWithPermissions\(\) method don't work when we pass more permissions than one in array [\#525](https://github.com/lonnieezell/myth-auth/issues/525)
- After auth:publish some config file variables values incorrect [\#390](https://github.com/lonnieezell/myth-auth/issues/390)
- Issue in Reset Password with database postgre [\#324](https://github.com/lonnieezell/myth-auth/issues/324)
- Problem in all views [\#293](https://github.com/lonnieezell/myth-auth/issues/293)
- Improper redirecttion to '/' instead of site\_url\(\) or base\_url\(\) [\#266](https://github.com/lonnieezell/myth-auth/issues/266)

**Closed issues:**

- JWT Authentication Support [\#286](https://github.com/lonnieezell/myth-auth/issues/286)
- Resend activate hash doesn't generate new hash [\#531](https://github.com/lonnieezell/myth-auth/issues/531)
- login after restrictToGroups will not redirect me to same restricted page [\#529](https://github.com/lonnieezell/myth-auth/issues/529)
- An error occurred in the forgot password feature [\#528](https://github.com/lonnieezell/myth-auth/issues/528)
- Myth\Auth\Authorization\PermissionModel:doesUserHavePermission\(\) - Why Check group permissions? [\#524](https://github.com/lonnieezell/myth-auth/issues/524)
- php null coalescing assignment operator [\#521](https://github.com/lonnieezell/myth-auth/issues/521)
- How do I change the error response? [\#490](https://github.com/lonnieezell/myth-auth/issues/490)
- Helper not loading in BaseController - Call to undefined function logged\_in\(\) [\#486](https://github.com/lonnieezell/myth-auth/issues/486)
- Argument 2 passed to Myth\Auth\Password::verify\(\) must be of the type string, null given [\#485](https://github.com/lonnieezell/myth-auth/issues/485)
- ErrorException Trying to get property 'password\_hash' of non-object [\#482](https://github.com/lonnieezell/myth-auth/issues/482)
- restrictWithPermissions\(\) with Multiple permissions [\#475](https://github.com/lonnieezell/myth-auth/issues/475)
- Redirect on web hosting not working [\#473](https://github.com/lonnieezell/myth-auth/issues/473)
- Email Configuration [\#472](https://github.com/lonnieezell/myth-auth/issues/472)
- Permissions is not an object [\#469](https://github.com/lonnieezell/myth-auth/issues/469)
- block failed login or show recaptcha after few invalid logins [\#466](https://github.com/lonnieezell/myth-auth/issues/466)
- Ajax call not working  [\#465](https://github.com/lonnieezell/myth-auth/issues/465)
- Resend activate account not working [\#459](https://github.com/lonnieezell/myth-auth/issues/459)
- admin database does not migrate [\#458](https://github.com/lonnieezell/myth-auth/issues/458)
- add Google login [\#454](https://github.com/lonnieezell/myth-auth/issues/454)
- Problem to create custom Routing [\#453](https://github.com/lonnieezell/myth-auth/issues/453)
- LoginFilter creates redirect loop if forceGlobalSecureRequests is set with defined baseURI. [\#448](https://github.com/lonnieezell/myth-auth/issues/448)
- Use only email for registration and username for login [\#446](https://github.com/lonnieezell/myth-auth/issues/446)
- Call to undefined function in\_group\(\) error [\#445](https://github.com/lonnieezell/myth-auth/issues/445)
- ISSUE redirect if use filter login at $globals [\#443](https://github.com/lonnieezell/myth-auth/issues/443)
- Bug - Myth lang files have precedence over lang files located inside app folder [\#441](https://github.com/lonnieezell/myth-auth/issues/441)
- Send Email Activation [\#439](https://github.com/lonnieezell/myth-auth/issues/439)
- create new user by command [\#432](https://github.com/lonnieezell/myth-auth/issues/432)
- Published Entity not extending src Entity [\#431](https://github.com/lonnieezell/myth-auth/issues/431)
- Cannot add new fields [\#430](https://github.com/lonnieezell/myth-auth/issues/430)
- Exception in $auth-\>attempt\($data\) [\#429](https://github.com/lonnieezell/myth-auth/issues/429)
- The requested resource /login was not found on this server. [\#425](https://github.com/lonnieezell/myth-auth/issues/425)
- run this library without php spark [\#419](https://github.com/lonnieezell/myth-auth/issues/419)
- Undefined variable $config  [\#416](https://github.com/lonnieezell/myth-auth/issues/416)
- API with json [\#415](https://github.com/lonnieezell/myth-auth/issues/415)
- how do I change the password settings of a user? [\#414](https://github.com/lonnieezell/myth-auth/issues/414)
- Login / Logout loop [\#411](https://github.com/lonnieezell/myth-auth/issues/411)
- How can we use UUID except auto increment ID with this library? [\#408](https://github.com/lonnieezell/myth-auth/issues/408)
- VENDORPATH\myth\auth\src\Config\Services.php at line 92 [\#397](https://github.com/lonnieezell/myth-auth/issues/397)
- InvalidArgumentException Cache key contains reserved characters {}\(\)/\@: [\#396](https://github.com/lonnieezell/myth-auth/issues/396)
- auth page not working when I add login filter globally [\#393](https://github.com/lonnieezell/myth-auth/issues/393)
- Migrate Laravel 6 Users to Myth [\#389](https://github.com/lonnieezell/myth-auth/issues/389)
- Failed To reset password [\#340](https://github.com/lonnieezell/myth-auth/issues/340)
- Resend email activation not working [\#339](https://github.com/lonnieezell/myth-auth/issues/339)
- Document Password Reset [\#333](https://github.com/lonnieezell/myth-auth/issues/333)
- Multiple Login System [\#332](https://github.com/lonnieezell/myth-auth/issues/332)
- Get last inserted id when registering new user [\#318](https://github.com/lonnieezell/myth-auth/issues/318)
- This user account is not yet activated [\#314](https://github.com/lonnieezell/myth-auth/issues/314)
- Trying to install manually results in 404 errors. [\#312](https://github.com/lonnieezell/myth-auth/issues/312)
- \_header and \_footer views seem to be unused [\#300](https://github.com/lonnieezell/myth-auth/issues/300)
- Question about redirect\_url [\#288](https://github.com/lonnieezell/myth-auth/issues/288)
- Extend Entity User to change date format to create\_at and updated\_at [\#273](https://github.com/lonnieezell/myth-auth/issues/273)
- use only email / password ?  [\#265](https://github.com/lonnieezell/myth-auth/issues/265)
- 500 error if use strong\_password rule [\#258](https://github.com/lonnieezell/myth-auth/issues/258)
- `NothingPersonalValidator.php` Exception, if $email is empty [\#254](https://github.com/lonnieezell/myth-auth/issues/254)
- Activate-Account as an exception in login filter [\#240](https://github.com/lonnieezell/myth-auth/issues/240)
- Extend or change Language File [\#202](https://github.com/lonnieezell/myth-auth/issues/202)

**Merged pull requests:**

- Parameter Cast [\#541](https://github.com/lonnieezell/myth-auth/pull/541) ([MGatner](https://github.com/MGatner))
- Replace `route_to()` [\#540](https://github.com/lonnieezell/myth-auth/pull/540) ([MGatner](https://github.com/MGatner))
- Validation Extensions [\#539](https://github.com/lonnieezell/myth-auth/pull/539) ([MGatner](https://github.com/MGatner))
- User Type [\#537](https://github.com/lonnieezell/myth-auth/pull/537) ([MGatner](https://github.com/MGatner))
- Enforce password type [\#536](https://github.com/lonnieezell/myth-auth/pull/536) ([MGatner](https://github.com/MGatner))
- Update Development Tools [\#532](https://github.com/lonnieezell/myth-auth/pull/532) ([MGatner](https://github.com/MGatner))
- Removed redundant group permissions db lookup [\#530](https://github.com/lonnieezell/myth-auth/pull/530) ([manageruz](https://github.com/manageruz))
- Update PermissionModel.php [\#526](https://github.com/lonnieezell/myth-auth/pull/526) ([sclubricants](https://github.com/sclubricants))
- updated commands doc file, added 3 new parts [\#523](https://github.com/lonnieezell/myth-auth/pull/523) ([manageruz](https://github.com/manageruz))
- Add new command of list registered. [\#519](https://github.com/lonnieezell/myth-auth/pull/519) ([anjooficial](https://github.com/anjooficial))
- CodeIgniter DevKit [\#517](https://github.com/lonnieezell/myth-auth/pull/517) ([MGatner](https://github.com/MGatner))
- fix namespace entity ci 4.1.9 [\#514](https://github.com/lonnieezell/myth-auth/pull/514) ([agiltriyas](https://github.com/agiltriyas))
- Entity encapsulation namespace and documentation update [\#511](https://github.com/lonnieezell/myth-auth/pull/511) ([lyimolucasl](https://github.com/lyimolucasl))
- update documentation typo [\#502](https://github.com/lonnieezell/myth-auth/pull/502) ([lyimolucasl](https://github.com/lyimolucasl))
- Respect routing when generating e-mail links [\#501](https://github.com/lonnieezell/myth-auth/pull/501) ([rmilecki](https://github.com/rmilecki))
- Update spanish \(Spain\) translation [\#496](https://github.com/lonnieezell/myth-auth/pull/496) ([treborin](https://github.com/treborin))
- PostgreSQL support - proposal n.1: without change in database schema [\#494](https://github.com/lonnieezell/myth-auth/pull/494) ([xlii-chl](https://github.com/xlii-chl))
- permit multiple permissions in restrictWithPermissions\(\) [\#481](https://github.com/lonnieezell/myth-auth/pull/481) ([paul45](https://github.com/paul45))
- Update RU language [\#462](https://github.com/lonnieezell/myth-auth/pull/462) ([oleg1540](https://github.com/oleg1540))
- docs: highlight PHP code blocks [\#461](https://github.com/lonnieezell/myth-auth/pull/461) ([kenjis](https://github.com/kenjis))
- Update authentication.md [\#457](https://github.com/lonnieezell/myth-auth/pull/457) ([jdavidson-hhg](https://github.com/jdavidson-hhg))
- Re-work the filters & Set the route name for routing in config [\#444](https://github.com/lonnieezell/myth-auth/pull/444) ([mjamilasfihani](https://github.com/mjamilasfihani))
- Add validation rules for email attemptForgot\(\) [\#435](https://github.com/lonnieezell/myth-auth/pull/435) ([Eelisland](https://github.com/Eelisland))
- Text correction [\#434](https://github.com/lonnieezell/myth-auth/pull/434) ([daycry](https://github.com/daycry))
- Fix bug in published User Entity and UserModel [\#433](https://github.com/lonnieezell/myth-auth/pull/433) ([Eelisland](https://github.com/Eelisland))
- Added missing open block comment asterisk sign [\#424](https://github.com/lonnieezell/myth-auth/pull/424) ([lyimolucasl](https://github.com/lyimolucasl))
- Fix Translation [\#412](https://github.com/lonnieezell/myth-auth/pull/412) ([teddcm](https://github.com/teddcm))
- Fix wrong translation [\#410](https://github.com/lonnieezell/myth-auth/pull/410) ([nynsen](https://github.com/nynsen))
- Fix namespace to path sync of views files during publish [\#407](https://github.com/lonnieezell/myth-auth/pull/407) ([paulbalandan](https://github.com/paulbalandan))
- Use "env" key instead of additional workflow step [\#406](https://github.com/lonnieezell/myth-auth/pull/406) ([paulbalandan](https://github.com/paulbalandan))

## [v1.0.1](https://github.com/lonnieezell/myth-auth/tree/v1.0.1) (2021-07-02)

[Full Changelog](https://github.com/lonnieezell/myth-auth/compare/v1.0...v1.0.1)

**Closed issues:**

- Validation from \Config\Services::validation\(\) is no longer worked in frontend after implementing Myth/Auth [\#395](https://github.com/lonnieezell/myth-auth/issues/395)
- Improve IPv6 support [\#392](https://github.com/lonnieezell/myth-auth/issues/392)
- var $requireActivation on config not working for disable activation user when register [\#382](https://github.com/lonnieezell/myth-auth/issues/382)
- Question : How to login programmatically from controller without password or use loginById Function from AuthenticationBase ?  [\#379](https://github.com/lonnieezell/myth-auth/issues/379)
- Cache key contains reserved characters {}\(\)/\@ [\#378](https://github.com/lonnieezell/myth-auth/issues/378)
- broken link in docs/extending.md [\#374](https://github.com/lonnieezell/myth-auth/issues/374)
- BadMethodCallException when i add new fields [\#370](https://github.com/lonnieezell/myth-auth/issues/370)
- localhost redirected you too many times. [\#365](https://github.com/lonnieezell/myth-auth/issues/365)
- Delete a user [\#364](https://github.com/lonnieezell/myth-auth/issues/364)
- Cache Reserved Characters [\#359](https://github.com/lonnieezell/myth-auth/issues/359)
- Tests fail on composer auth [\#336](https://github.com/lonnieezell/myth-auth/issues/336)
- Cache issues [\#334](https://github.com/lonnieezell/myth-auth/issues/334)

**Merged pull requests:**

- Remove Roave Workflow [\#399](https://github.com/lonnieezell/myth-auth/pull/399) ([MGatner](https://github.com/MGatner))
- Remove cache of group after delete/add user to group [\#398](https://github.com/lonnieezell/myth-auth/pull/398) ([WebStarVenlo](https://github.com/WebStarVenlo))
- Created the method "usersInGroup" in the src\Authorization\FlatAuthorization.php file [\#391](https://github.com/lonnieezell/myth-auth/pull/391) ([rafinhaa](https://github.com/rafinhaa))
- Apply static analysis [\#387](https://github.com/lonnieezell/myth-auth/pull/387) ([MGatner](https://github.com/MGatner))
- Fix cache\(\) return value checks. [\#386](https://github.com/lonnieezell/myth-auth/pull/386) ([sfadschm](https://github.com/sfadschm))
- Update development toolkit [\#383](https://github.com/lonnieezell/myth-auth/pull/383) ([MGatner](https://github.com/MGatner))
- Update AuthController.php [\#381](https://github.com/lonnieezell/myth-auth/pull/381) ([snelledre](https://github.com/snelledre))
- fix small typo: Models -\> Entities [\#380](https://github.com/lonnieezell/myth-auth/pull/380) ([hatsat32](https://github.com/hatsat32))
- Prevalidate user fields [\#377](https://github.com/lonnieezell/myth-auth/pull/377) ([MGatner](https://github.com/MGatner))
- Update extending.md [\#376](https://github.com/lonnieezell/myth-auth/pull/376) ([mjamilasfihani](https://github.com/mjamilasfihani))
- Fix typo activate user. It is a method, not variable. [\#375](https://github.com/lonnieezell/myth-auth/pull/375) ([adjiekrazz](https://github.com/adjiekrazz))
- Update docs for release [\#369](https://github.com/lonnieezell/myth-auth/pull/369) ([MGatner](https://github.com/MGatner))

## [v1.0](https://github.com/lonnieezell/myth-auth/tree/v1.0) (2021-06-10)

[Full Changelog](https://github.com/lonnieezell/myth-auth/compare/1.0-beta.3...v1.0)

**Closed issues:**

- Login Filter before error in version 4.1.2 [\#361](https://github.com/lonnieezell/myth-auth/issues/361)
- My own attributes are always empty when a new user is created [\#357](https://github.com/lonnieezell/myth-auth/issues/357)
- Add translatable language brick in PwnedValidator.php  [\#341](https://github.com/lonnieezell/myth-auth/issues/341)
- DB migration is missing 'if not exists' [\#337](https://github.com/lonnieezell/myth-auth/issues/337)
- Question : Changes Password [\#331](https://github.com/lonnieezell/myth-auth/issues/331)
- Extending AuthenticationBase [\#330](https://github.com/lonnieezell/myth-auth/issues/330)
- Incompatibility filter login with forceGlobalSecureRequests [\#325](https://github.com/lonnieezell/myth-auth/issues/325)
- changing 'users' table name to 'auth\_users'  [\#315](https://github.com/lonnieezell/myth-auth/issues/315)
- my own attributes always return null [\#311](https://github.com/lonnieezell/myth-auth/issues/311)
- This user account is not yet activated [\#310](https://github.com/lonnieezell/myth-auth/issues/310)
- change password [\#308](https://github.com/lonnieezell/myth-auth/issues/308)
- 60 : SSL certificate problem: unable to get local issuer certificate  [\#307](https://github.com/lonnieezell/myth-auth/issues/307)
- Blocked user [\#303](https://github.com/lonnieezell/myth-auth/issues/303)
- Problem with PermissionFilter [\#302](https://github.com/lonnieezell/myth-auth/issues/302)
- Why is there a "src/zxcvbn.js" file? [\#299](https://github.com/lonnieezell/myth-auth/issues/299)
- Migate success with error [\#298](https://github.com/lonnieezell/myth-auth/issues/298)
- Get all users by groups name [\#297](https://github.com/lonnieezell/myth-auth/issues/297)
- Trying to get property 'userActivators' of non-object [\#295](https://github.com/lonnieezell/myth-auth/issues/295)
- Trying to get property 'userResetters' of non-object [\#294](https://github.com/lonnieezell/myth-auth/issues/294)
- Error in registering new user [\#289](https://github.com/lonnieezell/myth-auth/issues/289)
- New Download Missing these [\#285](https://github.com/lonnieezell/myth-auth/issues/285)
- Error when restricting access via single route  [\#284](https://github.com/lonnieezell/myth-auth/issues/284)
- Feature: Factory Models [\#281](https://github.com/lonnieezell/myth-auth/issues/281)
- \[SUGGESTION\] Authentication more modular. [\#279](https://github.com/lonnieezell/myth-auth/issues/279)
- How to add default value of personal field? [\#278](https://github.com/lonnieezell/myth-auth/issues/278)
- Add Username Restricted [\#277](https://github.com/lonnieezell/myth-auth/issues/277)
- Call to a member function generateResetHash\(\) on array  [\#276](https://github.com/lonnieezell/myth-auth/issues/276)
- Filter not redirect resend-activate-account - Fix [\#275](https://github.com/lonnieezell/myth-auth/issues/275)
- Filters not upto the FilterInterface set by CodeIgniter 4.0.4 [\#274](https://github.com/lonnieezell/myth-auth/issues/274)
- errorexception \#64 [\#272](https://github.com/lonnieezell/myth-auth/issues/272)
- Can I work on server? My Did not work ? [\#264](https://github.com/lonnieezell/myth-auth/issues/264)
- filters don't redirect [\#260](https://github.com/lonnieezell/myth-auth/issues/260)
- \[Question\] Group Filter [\#259](https://github.com/lonnieezell/myth-auth/issues/259)
- Requirements [\#257](https://github.com/lonnieezell/myth-auth/issues/257)
- Fatal error: Declaration of Myth\Auth\Filters\RoleFilter::after [\#255](https://github.com/lonnieezell/myth-auth/issues/255)
- Login Filter before error in version 4.0.4 [\#253](https://github.com/lonnieezell/myth-auth/issues/253)
- How to add new fields to the record [\#252](https://github.com/lonnieezell/myth-auth/issues/252)
- didnt work for me [\#251](https://github.com/lonnieezell/myth-auth/issues/251)
- Update filter with CI 4.04 [\#249](https://github.com/lonnieezell/myth-auth/issues/249)
- Delete cache in GroupModel [\#239](https://github.com/lonnieezell/myth-auth/issues/239)
- Logout fails \(feature tests\) [\#237](https://github.com/lonnieezell/myth-auth/issues/237)
- Logout fails for deleted user [\#236](https://github.com/lonnieezell/myth-auth/issues/236)
- Database configuration [\#235](https://github.com/lonnieezell/myth-auth/issues/235)
- Call to undefined method CodeIgniter\HTTP\RedirectResponse::withCookies\(\) [\#231](https://github.com/lonnieezell/myth-auth/issues/231)
- route\_to issue [\#198](https://github.com/lonnieezell/myth-auth/issues/198)

**Merged pull requests:**

- Username Constraints [\#366](https://github.com/lonnieezell/myth-auth/pull/366) ([MGatner](https://github.com/MGatner))
- Add slovak translation [\#363](https://github.com/lonnieezell/myth-auth/pull/363) ([jozefrebjak](https://github.com/jozefrebjak))
- Typo in Dutch translation [\#360](https://github.com/lonnieezell/myth-auth/pull/360) ([bedrijfsportaal](https://github.com/bedrijfsportaal))
- fix some typos [\#358](https://github.com/lonnieezell/myth-auth/pull/358) ([sba](https://github.com/sba))
- refactor: replace `Config\Services` with service helper [\#356](https://github.com/lonnieezell/myth-auth/pull/356) ([yassinedoghri](https://github.com/yassinedoghri))
- fix\(types\): update wrong types in AuthConfig + declarations [\#355](https://github.com/lonnieezell/myth-auth/pull/355) ([yassinedoghri](https://github.com/yassinedoghri))
- Conditional Workflow Authentication [\#354](https://github.com/lonnieezell/myth-auth/pull/354) ([MGatner](https://github.com/MGatner))
- Remove Composer Auth [\#353](https://github.com/lonnieezell/myth-auth/pull/353) ([MGatner](https://github.com/MGatner))
- Enable Auth Token [\#352](https://github.com/lonnieezell/myth-auth/pull/352) ([MGatner](https://github.com/MGatner))
- fix\(typings\): update broken properties types in FlatAuthorization [\#347](https://github.com/lonnieezell/myth-auth/pull/347) ([yassinedoghri](https://github.com/yassinedoghri))
- Added language module for database in PwnedValidator.php \#341 / Added German translation [\#344](https://github.com/lonnieezell/myth-auth/pull/344) ([ballpumpe](https://github.com/ballpumpe))
- new translation [\#343](https://github.com/lonnieezell/myth-auth/pull/343) ([hendrasob](https://github.com/hendrasob))
- New: The Password class. [\#342](https://github.com/lonnieezell/myth-auth/pull/342) ([iRedds](https://github.com/iRedds))
- Added ‘IF NOT EXISTS’ value to tables [\#338](https://github.com/lonnieezell/myth-auth/pull/338) ([TimZ99](https://github.com/TimZ99))
- Added dutch translation [\#335](https://github.com/lonnieezell/myth-auth/pull/335) ([TimZ99](https://github.com/TimZ99))
- Fix force global secure requests [\#329](https://github.com/lonnieezell/myth-auth/pull/329) ([GuxMartin](https://github.com/GuxMartin))
- Missing translations [\#326](https://github.com/lonnieezell/myth-auth/pull/326) ([GuxMartin](https://github.com/GuxMartin))
- Add Composer provision [\#323](https://github.com/lonnieezell/myth-auth/pull/323) ([MGatner](https://github.com/MGatner))
- Refresh development toolkit [\#322](https://github.com/lonnieezell/myth-auth/pull/322) ([MGatner](https://github.com/MGatner))
- fix cookies configuration and expiration. [\#317](https://github.com/lonnieezell/myth-auth/pull/317) ([colethorsen](https://github.com/colethorsen))
- Tighten Activator Classes [\#306](https://github.com/lonnieezell/myth-auth/pull/306) ([MGatner](https://github.com/MGatner))
- Tighten Resetter Classes [\#305](https://github.com/lonnieezell/myth-auth/pull/305) ([MGatner](https://github.com/MGatner))
- Active resetter type [\#304](https://github.com/lonnieezell/myth-auth/pull/304) ([MGatner](https://github.com/MGatner))
- typo [\#301](https://github.com/lonnieezell/myth-auth/pull/301) ([pizzolante](https://github.com/pizzolante))
- Update AuthController.php [\#296](https://github.com/lonnieezell/myth-auth/pull/296) ([timothyenglish](https://github.com/timothyenglish))
- Some useful commands for development [\#292](https://github.com/lonnieezell/myth-auth/pull/292) ([najdanovicivan](https://github.com/najdanovicivan))
- Use Model factory for test trait [\#291](https://github.com/lonnieezell/myth-auth/pull/291) ([MGatner](https://github.com/MGatner))
- Add test method, test docs [\#287](https://github.com/lonnieezell/myth-auth/pull/287) ([MGatner](https://github.com/MGatner))
- Development Toolkit Update [\#283](https://github.com/lonnieezell/myth-auth/pull/283) ([MGatner](https://github.com/MGatner))
- Refactor models to use Factories [\#282](https://github.com/lonnieezell/myth-auth/pull/282) ([MGatner](https://github.com/MGatner))
- add french translation [\#280](https://github.com/lonnieezell/myth-auth/pull/280) ([yassinedoghri](https://github.com/yassinedoghri))
- Document config classes using DocBlock [\#271](https://github.com/lonnieezell/myth-auth/pull/271) ([paulbalandan](https://github.com/paulbalandan))
- Fixed improper redirection issue \#266 with site\_url instead of base\_url to include index.php if required [\#270](https://github.com/lonnieezell/myth-auth/pull/270) ([abusalam](https://github.com/abusalam))
- Correct return type [\#269](https://github.com/lonnieezell/myth-auth/pull/269) ([MGatner](https://github.com/MGatner))
- Delete permissions cache with groups cache in GroupModel [\#268](https://github.com/lonnieezell/myth-auth/pull/268) ([yassinedoghri](https://github.com/yassinedoghri))
- Update LoginFilter.php [\#263](https://github.com/lonnieezell/myth-auth/pull/263) ([Momenoor](https://github.com/Momenoor))
- small-fixed-in-toolbar [\#262](https://github.com/lonnieezell/myth-auth/pull/262) ([enix-app](https://github.com/enix-app))
- Using custom view [\#261](https://github.com/lonnieezell/myth-auth/pull/261) ([enix-app](https://github.com/enix-app))
- Implement updated interface arguments [\#250](https://github.com/lonnieezell/myth-auth/pull/250) ([MGatner](https://github.com/MGatner))
- Add test trait [\#247](https://github.com/lonnieezell/myth-auth/pull/247) ([MGatner](https://github.com/MGatner))
- Define and implement Permission exception [\#246](https://github.com/lonnieezell/myth-auth/pull/246) ([MGatner](https://github.com/MGatner))
- Add 'force' option in Publish Command [\#245](https://github.com/lonnieezell/myth-auth/pull/245) ([paulbalandan](https://github.com/paulbalandan))
- Add getUsersForGroup [\#244](https://github.com/lonnieezell/myth-auth/pull/244) ([MGatner](https://github.com/MGatner))
- Allow customized views when publishing the Config [\#243](https://github.com/lonnieezell/myth-auth/pull/243) ([paulbalandan](https://github.com/paulbalandan))
- Remove unused BaseConfig on publish of Config [\#242](https://github.com/lonnieezell/myth-auth/pull/242) ([paulbalandan](https://github.com/paulbalandan))
- Clear user property on logout [\#238](https://github.com/lonnieezell/myth-auth/pull/238) ([MGatner](https://github.com/MGatner))
- Update test scaffold for framework latest [\#234](https://github.com/lonnieezell/myth-auth/pull/234) ([MGatner](https://github.com/MGatner))
- Add Fakers to source [\#233](https://github.com/lonnieezell/myth-auth/pull/233) ([MGatner](https://github.com/MGatner))
- Cookie changes [\#232](https://github.com/lonnieezell/myth-auth/pull/232) ([erikkloeze](https://github.com/erikkloeze))
- Fix tests for validation rules [\#230](https://github.com/lonnieezell/myth-auth/pull/230) ([michalsn](https://github.com/michalsn))

## [1.0-beta.3](https://github.com/lonnieezell/myth-auth/tree/1.0-beta.3) (2020-05-12)

[Full Changelog](https://github.com/lonnieezell/myth-auth/compare/1.0-beta.2...1.0-beta.3)

**Implemented enhancements:**

- \[Request\] Add new feature on user entity getRoles\(\) [\#179](https://github.com/lonnieezell/myth-auth/issues/179)
- Add ability to publish filters [\#175](https://github.com/lonnieezell/myth-auth/issues/175)
- Resend activation email feature. [\#148](https://github.com/lonnieezell/myth-auth/issues/148)

**Fixed bugs:**

- LIbrary allows create two groups with same name [\#147](https://github.com/lonnieezell/myth-auth/issues/147)

**Closed issues:**

- Remove email system inside activation interface [\#224](https://github.com/lonnieezell/myth-auth/issues/224)
- OTP or Authenticator ? [\#219](https://github.com/lonnieezell/myth-auth/issues/219)
- Not logged in after successfull login attempt. [\#218](https://github.com/lonnieezell/myth-auth/issues/218)
- How to access user attributes? [\#212](https://github.com/lonnieezell/myth-auth/issues/212)
- "Remember me" function [\#211](https://github.com/lonnieezell/myth-auth/issues/211)
- ValidatioRule "strong\_password" conflict validation system [\#210](https://github.com/lonnieezell/myth-auth/issues/210)
- Can I seed users from begining without using register function? [\#209](https://github.com/lonnieezell/myth-auth/issues/209)
-   \[InvalidArgumentException\] [\#208](https://github.com/lonnieezell/myth-auth/issues/208)
- auth.validFields in .env file are ignored [\#207](https://github.com/lonnieezell/myth-auth/issues/207)
- $defaultUserGroup missing [\#206](https://github.com/lonnieezell/myth-auth/issues/206)
- register exception missing in LoginFilter-\>before [\#205](https://github.com/lonnieezell/myth-auth/issues/205)
- Helper. Bug at logged\_in function [\#204](https://github.com/lonnieezell/myth-auth/issues/204)
- Required fields for registration [\#203](https://github.com/lonnieezell/myth-auth/issues/203)
- Error on Insert new User [\#201](https://github.com/lonnieezell/myth-auth/issues/201)
- Infinite loop on register URL [\#200](https://github.com/lonnieezell/myth-auth/issues/200)
- Remember user or email on submit login form [\#199](https://github.com/lonnieezell/myth-auth/issues/199)
- change password function [\#195](https://github.com/lonnieezell/myth-auth/issues/195)
- Use an existing table instead of `users` table for authentication [\#191](https://github.com/lonnieezell/myth-auth/issues/191)
- Error when running "php spark migrate -all" [\#189](https://github.com/lonnieezell/myth-auth/issues/189)
- attemptLogin\(\) with force\_pass\_reset [\#183](https://github.com/lonnieezell/myth-auth/issues/183)
- \[Request\] Events [\#182](https://github.com/lonnieezell/myth-auth/issues/182)
- CLI command to create\_user fails - password\_hash is required [\#180](https://github.com/lonnieezell/myth-auth/issues/180)
- \[HELP\] Automatic Logins [\#174](https://github.com/lonnieezell/myth-auth/issues/174)
- Extension to AuthController fails to "use" custom User entity & model [\#173](https://github.com/lonnieezell/myth-auth/issues/173)
- Potential Security Issues [\#172](https://github.com/lonnieezell/myth-auth/issues/172)
- \[Question, Help\] How i do to check list of permissions\(\) if used by user then disable delete  [\#170](https://github.com/lonnieezell/myth-auth/issues/170)
- SUGESTION: change throw exception filter [\#169](https://github.com/lonnieezell/myth-auth/issues/169)
- Bug: PermissionModel, function doesUserHavePermission [\#165](https://github.com/lonnieezell/myth-auth/issues/165)
- Default groups when registering [\#164](https://github.com/lonnieezell/myth-auth/issues/164)
- function isLoggedIn inside AuthenticationBase always fails [\#163](https://github.com/lonnieezell/myth-auth/issues/163)
- Question, Help [\#161](https://github.com/lonnieezell/myth-auth/issues/161)
- Consideration: Change username validation [\#159](https://github.com/lonnieezell/myth-auth/issues/159)
- Cannot view Register and Activate Account pages if Auth is set to work globally [\#158](https://github.com/lonnieezell/myth-auth/issues/158)
- Login: show error message when username/email is not record on database [\#154](https://github.com/lonnieezell/myth-auth/issues/154)
- find the permissions of a group [\#152](https://github.com/lonnieezell/myth-auth/issues/152)
- redirect [\#151](https://github.com/lonnieezell/myth-auth/issues/151)
- When the user is logged in, the user should not be able to enter the register page. [\#149](https://github.com/lonnieezell/myth-auth/issues/149)
- Can't create "Users" table - Foreign key constraint is incorrectly formed [\#144](https://github.com/lonnieezell/myth-auth/issues/144)

**Merged pull requests:**

- Filter post data on registration [\#229](https://github.com/lonnieezell/myth-auth/pull/229) ([michalsn](https://github.com/michalsn))
- Make resetting password more customizable [\#228](https://github.com/lonnieezell/myth-auth/pull/228) ([michalsn](https://github.com/michalsn))
- Test fixes [\#226](https://github.com/lonnieezell/myth-auth/pull/226) ([michalsn](https://github.com/michalsn))
- Redirect with cookies [\#225](https://github.com/lonnieezell/myth-auth/pull/225) ([michalsn](https://github.com/michalsn))
- Added russian language [\#223](https://github.com/lonnieezell/myth-auth/pull/223) ([oleg1540](https://github.com/oleg1540))
- Support for assigning validation data to strong\_password method [\#222](https://github.com/lonnieezell/myth-auth/pull/222) ([michalsn](https://github.com/michalsn))
- Switch to using check method in logged\_in. Fixes \#204 [\#221](https://github.com/lonnieezell/myth-auth/pull/221) ([lonnieezell](https://github.com/lonnieezell))
- Add register route as exception in LoginFilter. Fixes \#205 [\#220](https://github.com/lonnieezell/myth-auth/pull/220) ([lonnieezell](https://github.com/lonnieezell))
- Add docs for defaultUserGroup config variable [\#217](https://github.com/lonnieezell/myth-auth/pull/217) ([michalsn](https://github.com/michalsn))
- Fix the call for validation errors messages [\#216](https://github.com/lonnieezell/myth-auth/pull/216) ([michalsn](https://github.com/michalsn))
- Update README.md [\#197](https://github.com/lonnieezell/myth-auth/pull/197) ([JamesShaver](https://github.com/JamesShaver))
- Force pass reset [\#194](https://github.com/lonnieezell/myth-auth/pull/194) ([erikkloeze](https://github.com/erikkloeze))
- Remove `extra` `use` statement in `Login Model` [\#193](https://github.com/lonnieezell/myth-auth/pull/193) ([atefBB](https://github.com/atefBB))
- Banned user error message [\#192](https://github.com/lonnieezell/myth-auth/pull/192) ([erikkloeze](https://github.com/erikkloeze))
- Fix namespace group model [\#190](https://github.com/lonnieezell/myth-auth/pull/190) ([agungsugiarto](https://github.com/agungsugiarto))
- User entity in Validation Rules [\#188](https://github.com/lonnieezell/myth-auth/pull/188) ([erikkloeze](https://github.com/erikkloeze))
- Add function getRoles\(\) on user entity [\#186](https://github.com/lonnieezell/myth-auth/pull/186) ([agungsugiarto](https://github.com/agungsugiarto))
- Update authorization.md [\#178](https://github.com/lonnieezell/myth-auth/pull/178) ([JamesShaver](https://github.com/JamesShaver))
- Italian translation [\#177](https://github.com/lonnieezell/myth-auth/pull/177) ([Vizzielli](https://github.com/Vizzielli))
- Add filter publishing [\#176](https://github.com/lonnieezell/myth-auth/pull/176) ([michalsn](https://github.com/michalsn))
- Add Brazilian Portuguese translation [\#171](https://github.com/lonnieezell/myth-auth/pull/171) ([diegovernan](https://github.com/diegovernan))
- Fix doesUserHavePermission \#165 [\#168](https://github.com/lonnieezell/myth-auth/pull/168) ([michalsn](https://github.com/michalsn))
- Fix tests [\#167](https://github.com/lonnieezell/myth-auth/pull/167) ([michalsn](https://github.com/michalsn))
- Add validation for creating groups and permissions [\#166](https://github.com/lonnieezell/myth-auth/pull/166) ([michalsn](https://github.com/michalsn))
- Missing invalidPassword key in language files [\#162](https://github.com/lonnieezell/myth-auth/pull/162) ([eafarooqi](https://github.com/eafarooqi))
- Add option to resend activation code - fix \#148 [\#160](https://github.com/lonnieezell/myth-auth/pull/160) ([michalsn](https://github.com/michalsn))
- Add required fields to CreateUser [\#157](https://github.com/lonnieezell/myth-auth/pull/157) ([MGatner](https://github.com/MGatner))
- Modified AuthController-\>attemptRegister\(\) validation rules [\#155](https://github.com/lonnieezell/myth-auth/pull/155) ([rodrigokestler](https://github.com/rodrigokestler))
- Group permissions \(from paul45\) [\#153](https://github.com/lonnieezell/myth-auth/pull/153) ([MGatner](https://github.com/MGatner))
- check if already logged in in register method [\#150](https://github.com/lonnieezell/myth-auth/pull/150) ([titounnes](https://github.com/titounnes))

## [1.0-beta.2](https://github.com/lonnieezell/myth-auth/tree/1.0-beta.2) (2019-12-12)

[Full Changelog](https://github.com/lonnieezell/myth-auth/compare/v1.0-beta...1.0-beta.2)

**Closed issues:**

- Change "return redirect\('/\);" to "return redirect\(\)-\>to\('/'\);" [\#143](https://github.com/lonnieezell/myth-auth/issues/143)
- ERROR Using PHP 7.4.0 Database [\#142](https://github.com/lonnieezell/myth-auth/issues/142)
- Feature: external authentication hooks [\#141](https://github.com/lonnieezell/myth-auth/issues/141)
- how override Config/Auth.php  [\#139](https://github.com/lonnieezell/myth-auth/issues/139)
- Please remove [\#136](https://github.com/lonnieezell/myth-auth/issues/136)
- Idea: Filter helper load [\#135](https://github.com/lonnieezell/myth-auth/issues/135)
- performance proposal - Store data in static variable [\#134](https://github.com/lonnieezell/myth-auth/issues/134)
- doesUserHavePermission [\#131](https://github.com/lonnieezell/myth-auth/issues/131)
- I can not change user password on check of current password [\#130](https://github.com/lonnieezell/myth-auth/issues/130)
- Issue on installing with composer [\#128](https://github.com/lonnieezell/myth-auth/issues/128)
- Undefined property CSRFHeaderName  [\#125](https://github.com/lonnieezell/myth-auth/issues/125)
- name is not a property of the Entity user [\#124](https://github.com/lonnieezell/myth-auth/issues/124)
- Error Register [\#118](https://github.com/lonnieezell/myth-auth/issues/118)
- Core Version [\#115](https://github.com/lonnieezell/myth-auth/issues/115)
- Permissions for user [\#106](https://github.com/lonnieezell/myth-auth/issues/106)
- Error with failed login [\#105](https://github.com/lonnieezell/myth-auth/issues/105)
- Validation errors [\#104](https://github.com/lonnieezell/myth-auth/issues/104)
- Request: interface for using Authorization [\#103](https://github.com/lonnieezell/myth-auth/issues/103)
- Publish views error [\#101](https://github.com/lonnieezell/myth-auth/issues/101)
- Error forgot password [\#100](https://github.com/lonnieezell/myth-auth/issues/100)
- Register Error [\#99](https://github.com/lonnieezell/myth-auth/issues/99)
- Reset\* vars in user don't get nullified when password is changed [\#95](https://github.com/lonnieezell/myth-auth/issues/95)
- LoginFilter messes with get's token parameter \(reset-password\) [\#94](https://github.com/lonnieezell/myth-auth/issues/94)
- Reset\* vars in user don't get nullified when password is changed [\#90](https://github.com/lonnieezell/myth-auth/issues/90)
- Myth's routes cannot be overridden by App's ones [\#89](https://github.com/lonnieezell/myth-auth/issues/89)
- Exception when logging in with non-existant username [\#87](https://github.com/lonnieezell/myth-auth/issues/87)
- AuthTrait redirects won't currently [\#86](https://github.com/lonnieezell/myth-auth/issues/86)
- Request: Publish to Packagist [\#84](https://github.com/lonnieezell/myth-auth/issues/84)
- Old version of Migration commands [\#77](https://github.com/lonnieezell/myth-auth/issues/77)
- CPU 100% [\#43](https://github.com/lonnieezell/myth-auth/issues/43)
- Social login [\#26](https://github.com/lonnieezell/myth-auth/issues/26)

**Merged pull requests:**

- Default return URL to previous page [\#146](https://github.com/lonnieezell/myth-auth/pull/146) ([MGatner](https://github.com/MGatner))
- Specify null return when no user [\#145](https://github.com/lonnieezell/myth-auth/pull/145) ([MGatner](https://github.com/MGatner))
- Added Turkish translation [\#140](https://github.com/lonnieezell/myth-auth/pull/140) ([hatsat32](https://github.com/hatsat32))
- Preload helpers on all filters [\#138](https://github.com/lonnieezell/myth-auth/pull/138) ([MGatner](https://github.com/MGatner))
- Install docs [\#137](https://github.com/lonnieezell/myth-auth/pull/137) ([MGatner](https://github.com/MGatner))
- Correct countAll to countAllResults [\#133](https://github.com/lonnieezell/myth-auth/pull/133) ([MGatner](https://github.com/MGatner))
- Replace invalidUser with badAttempt [\#132](https://github.com/lonnieezell/myth-auth/pull/132) ([MGatner](https://github.com/MGatner))
- Change isActive to be type agnostic [\#129](https://github.com/lonnieezell/myth-auth/pull/129) ([MGatner](https://github.com/MGatner))
- NothingPersonalValidator class [\#127](https://github.com/lonnieezell/myth-auth/pull/127) ([dafriend](https://github.com/dafriend))
- Implement view layout [\#123](https://github.com/lonnieezell/myth-auth/pull/123) ([MGatner](https://github.com/MGatner))
- Always use Config\Services to allow users to override with their own service. [\#122](https://github.com/lonnieezell/myth-auth/pull/122) ([lonnieezell](https://github.com/lonnieezell))
- Validation fix for username [\#121](https://github.com/lonnieezell/myth-auth/pull/121) ([michalsn](https://github.com/michalsn))
- Proposal - confirm registration \(optional\) [\#120](https://github.com/lonnieezell/myth-auth/pull/120) ([michalsn](https://github.com/michalsn))
- Provided links to summary and detail re: Flat RBAC [\#119](https://github.com/lonnieezell/myth-auth/pull/119) ([zigmoo](https://github.com/zigmoo))
- Fix user entity permissions [\#117](https://github.com/lonnieezell/myth-auth/pull/117) ([MGatner](https://github.com/MGatner))
- Update tests to new ModuleTests convention [\#116](https://github.com/lonnieezell/myth-auth/pull/116) ([MGatner](https://github.com/MGatner))
- Fixes \#104 [\#114](https://github.com/lonnieezell/myth-auth/pull/114) ([michalsn](https://github.com/michalsn))
- Fixes \#99 [\#113](https://github.com/lonnieezell/myth-auth/pull/113) ([michalsn](https://github.com/michalsn))
- Revise PwnedValidator::check\(\) [\#112](https://github.com/lonnieezell/myth-auth/pull/112) ([dafriend](https://github.com/dafriend))
- Fix token expired bug [\#111](https://github.com/lonnieezell/myth-auth/pull/111) ([michalsn](https://github.com/michalsn))
- Fixes \#100 [\#110](https://github.com/lonnieezell/myth-auth/pull/110) ([michalsn](https://github.com/michalsn))
- Check for allowRemembering in view [\#109](https://github.com/lonnieezell/myth-auth/pull/109) ([michalsn](https://github.com/michalsn))
- Add PwnedValidator [\#108](https://github.com/lonnieezell/myth-auth/pull/108) ([michalsn](https://github.com/michalsn))
- Fix validation rule bug for registration [\#107](https://github.com/lonnieezell/myth-auth/pull/107) ([michalsn](https://github.com/michalsn))
- Change mkdir to recurse [\#102](https://github.com/lonnieezell/myth-auth/pull/102) ([MGatner](https://github.com/MGatner))
- fix mistype in docs [\#98](https://github.com/lonnieezell/myth-auth/pull/98) ([hatsat32](https://github.com/hatsat32))
- Implement CIModuleTests [\#97](https://github.com/lonnieezell/myth-auth/pull/97) ([MGatner](https://github.com/MGatner))
- Set reset\* variables to null after password change [\#96](https://github.com/lonnieezell/myth-auth/pull/96) ([fefo-p](https://github.com/fefo-p))
- Add CLI command create\_user [\#92](https://github.com/lonnieezell/myth-auth/pull/92) ([MGatner](https://github.com/MGatner))
- Fixes \#87 [\#88](https://github.com/lonnieezell/myth-auth/pull/88) ([fefo-p](https://github.com/fefo-p))
- Update migrate command syntax [\#85](https://github.com/lonnieezell/myth-auth/pull/85) ([MGatner](https://github.com/MGatner))

## [v1.0-beta](https://github.com/lonnieezell/myth-auth/tree/v1.0-beta) (2019-08-29)

[Full Changelog](https://github.com/lonnieezell/myth-auth/compare/12eaf48540e0f20c5e5c9b2ba5ddaf8b4a893af0...v1.0-beta)

**Closed issues:**

- attemptReset does not check for token existance before resetting passwd [\#79](https://github.com/lonnieezell/myth-auth/issues/79)
- route to reset-password being redirected to login [\#78](https://github.com/lonnieezell/myth-auth/issues/78)
- Spanish text in view [\#75](https://github.com/lonnieezell/myth-auth/issues/75)
- PASSWORD\_ARGON2ID is a conditional constant [\#73](https://github.com/lonnieezell/myth-auth/issues/73)
- Rolefilter does not end well when more than one role is checked [\#64](https://github.com/lonnieezell/myth-auth/issues/64)
- Filter parameters don't seem to be in CI4 [\#38](https://github.com/lonnieezell/myth-auth/issues/38)
- Fresh install - Invalid File [\#33](https://github.com/lonnieezell/myth-auth/issues/33)
- discoverLocal [\#32](https://github.com/lonnieezell/myth-auth/issues/32)
- Config autoload causing Composer failures [\#31](https://github.com/lonnieezell/myth-auth/issues/31)
- Filter parameters [\#30](https://github.com/lonnieezell/myth-auth/issues/30)
- Permission error [\#27](https://github.com/lonnieezell/myth-auth/issues/27)
- Permission Model does not get User permissions [\#22](https://github.com/lonnieezell/myth-auth/issues/22)
- Permission ID not being get [\#20](https://github.com/lonnieezell/myth-auth/issues/20)
- $this-\>error in FlatAuthorization not being shown [\#19](https://github.com/lonnieezell/myth-auth/issues/19)
- Status "not logged in" message appears after logout [\#18](https://github.com/lonnieezell/myth-auth/issues/18)
- Application view files do not override packaged views. [\#17](https://github.com/lonnieezell/myth-auth/issues/17)
- Take builder out from $this-\>builder\(\)-\>select\(\) in GroupModel.php [\#11](https://github.com/lonnieezell/myth-auth/issues/11)
- Services::authorization\(\) instead of authentication\(\) [\#10](https://github.com/lonnieezell/myth-auth/issues/10)
- Routes read from Myth's config instead of App's config \(ie: will not read App AuthController\) [\#9](https://github.com/lonnieezell/myth-auth/issues/9)
- Missing Auth in namespace \(2\) [\#8](https://github.com/lonnieezell/myth-auth/issues/8)
- Missing Auth in namespace [\#7](https://github.com/lonnieezell/myth-auth/issues/7)
- redirect not working in AuthTrait [\#6](https://github.com/lonnieezell/myth-auth/issues/6)
- Missing id\(\) func in AuthenticationBase [\#5](https://github.com/lonnieezell/myth-auth/issues/5)
- Namespace: Auth missing [\#4](https://github.com/lonnieezell/myth-auth/issues/4)
- Namespace: should it be Myth\Auth\Authorization? [\#3](https://github.com/lonnieezell/myth-auth/issues/3)
- find\_all\(\) instead of findAll\(\) [\#2](https://github.com/lonnieezell/myth-auth/issues/2)
- as\_array\(\) instead of asArray\(\) [\#1](https://github.com/lonnieezell/myth-auth/issues/1)

**Merged pull requests:**

- Fix table name in down\(\) [\#83](https://github.com/lonnieezell/myth-auth/pull/83) ([MGatner](https://github.com/MGatner))
- Disable soft deletes on LoginModel [\#82](https://github.com/lonnieezell/myth-auth/pull/82) ([MGatner](https://github.com/MGatner))
- Fixes \#79 [\#81](https://github.com/lonnieezell/myth-auth/pull/81) ([fefo-p](https://github.com/fefo-p))
- Fixes \#78 [\#80](https://github.com/lonnieezell/myth-auth/pull/80) ([fefo-p](https://github.com/fefo-p))
- Added translation to static placeholders text \(fix \#75\) [\#76](https://github.com/lonnieezell/myth-auth/pull/76) ([fefo-p](https://github.com/fefo-p))
- Added defined\('PASSWORD\_ARGON2I'\) to condition check in user entity [\#74](https://github.com/lonnieezell/myth-auth/pull/74) ([fefo-p](https://github.com/fefo-p))
- Check for banned user upon login [\#72](https://github.com/lonnieezell/myth-auth/pull/72) ([fefo-p](https://github.com/fefo-p))
- Added group info to Toolbar debug info [\#71](https://github.com/lonnieezell/myth-auth/pull/71) ([fefo-p](https://github.com/fefo-p))
- Added spanish translation [\#70](https://github.com/lonnieezell/myth-auth/pull/70) ([fefo-p](https://github.com/fefo-p))
- Fixes \#64 inGroup method to check with OR instead of AND [\#69](https://github.com/lonnieezell/myth-auth/pull/69) ([fefo-p](https://github.com/fefo-p))
- Multiple hashing algorithm option [\#68](https://github.com/lonnieezell/myth-auth/pull/68) ([fefo-p](https://github.com/fefo-p))
- Add Auth helper and docs [\#62](https://github.com/lonnieezell/myth-auth/pull/62) ([MGatner](https://github.com/MGatner))
- Login fields respect $config-\>validFields [\#61](https://github.com/lonnieezell/myth-auth/pull/61) ([MGatner](https://github.com/MGatner))
- Leverage updated config\(\) functionality [\#60](https://github.com/lonnieezell/myth-auth/pull/60) ([MGatner](https://github.com/MGatner))
- Call user config class directly [\#58](https://github.com/lonnieezell/myth-auth/pull/58) ([MGatner](https://github.com/MGatner))
- Change filters to use $params as array [\#57](https://github.com/lonnieezell/myth-auth/pull/57) ([MGatner](https://github.com/MGatner))
- Change loginModel return type [\#56](https://github.com/lonnieezell/myth-auth/pull/56) ([MGatner](https://github.com/MGatner))
- Replace findWhere [\#55](https://github.com/lonnieezell/myth-auth/pull/55) ([MGatner](https://github.com/MGatner))
- Add missing close bracket [\#54](https://github.com/lonnieezell/myth-auth/pull/54) ([MGatner](https://github.com/MGatner))
- Update for `deleted_at` [\#53](https://github.com/lonnieezell/myth-auth/pull/53) ([MGatner](https://github.com/MGatner))
- Add redirects to filters [\#52](https://github.com/lonnieezell/myth-auth/pull/52) ([MGatner](https://github.com/MGatner))
- Add LoginFilter to check for any user [\#51](https://github.com/lonnieezell/myth-auth/pull/51) ([MGatner](https://github.com/MGatner))
- Add collector info, rename "application" path [\#50](https://github.com/lonnieezell/myth-auth/pull/50) ([MGatner](https://github.com/MGatner))
- Add support for `$allowRegistration` config setting [\#49](https://github.com/lonnieezell/myth-auth/pull/49) ([MGatner](https://github.com/MGatner))
- Change dash to underscore [\#48](https://github.com/lonnieezell/myth-auth/pull/48) ([titounnes](https://github.com/titounnes))
- change composite index for email to unique key. [\#47](https://github.com/lonnieezell/myth-auth/pull/47) ([titounnes](https://github.com/titounnes))
- Remove `name` field [\#46](https://github.com/lonnieezell/myth-auth/pull/46) ([MGatner](https://github.com/MGatner))
- Change command dashes to underscores [\#45](https://github.com/lonnieezell/myth-auth/pull/45) ([MGatner](https://github.com/MGatner))
- add a name field to match the AuthController line 141 [\#44](https://github.com/lonnieezell/myth-auth/pull/44) ([titounnes](https://github.com/titounnes))
- Add initial CLI commands [\#42](https://github.com/lonnieezell/myth-auth/pull/42) ([MGatner](https://github.com/MGatner))
- First pass at toolbar collector \(basic\) [\#41](https://github.com/lonnieezell/myth-auth/pull/41) ([MGatner](https://github.com/MGatner))
- Add login/logout events [\#40](https://github.com/lonnieezell/myth-auth/pull/40) ([MGatner](https://github.com/MGatner))
- Update filters, support silent operation, allow user config [\#39](https://github.com/lonnieezell/myth-auth/pull/39) ([MGatner](https://github.com/MGatner))
- Fix for \#17 \(low priority\) [\#37](https://github.com/lonnieezell/myth-auth/pull/37) ([MGatner](https://github.com/MGatner))
- Add missing bracket in validation [\#36](https://github.com/lonnieezell/myth-auth/pull/36) ([MGatner](https://github.com/MGatner))
- Drop constraints before tables [\#35](https://github.com/lonnieezell/myth-auth/pull/35) ([MGatner](https://github.com/MGatner))
- Fix Authorization service [\#34](https://github.com/lonnieezell/myth-auth/pull/34) ([MGatner](https://github.com/MGatner))
- Fix broken links to old user guide [\#29](https://github.com/lonnieezell/myth-auth/pull/29) ([MGatner](https://github.com/MGatner))
- Fix link formatting in README [\#28](https://github.com/lonnieezell/myth-auth/pull/28) ([MGatner](https://github.com/MGatner))
- Replace setMessage with setFlashdata [\#25](https://github.com/lonnieezell/myth-auth/pull/25) ([fefo-p](https://github.com/fefo-p))
- Get combined user & group permissions \(fixes \#22\) [\#24](https://github.com/lonnieezell/myth-auth/pull/24) ([fefo-p](https://github.com/fefo-p))
- Permission ID get \(fixes \#20\) [\#21](https://github.com/lonnieezell/myth-auth/pull/21) ([fefo-p](https://github.com/fefo-p))
- Namespace conversion on first install [\#16](https://github.com/lonnieezell/myth-auth/pull/16) ([fefo-p](https://github.com/fefo-p))
- Authorization missed calling [\#15](https://github.com/lonnieezell/myth-auth/pull/15) ([fefo-p](https://github.com/fefo-p))
- Authentication id\(\) method missing [\#14](https://github.com/lonnieezell/myth-auth/pull/14) ([fefo-p](https://github.com/fefo-p))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
